# Contributing

Contributions are **welcome**!

We accept contributions via Pull Requests on [Github](https://github.com/mateusjunges/laravel-acl).

If you don't know how to contribute, check the [jungessolutions/docs](https://github.com/jungessolutions/docs/blob/master/ACL.md) repository of this package.

## Pull Requests

- **[PSR-2 Coding Standard](https://github.com/php-fig/fig-standards/blob/master/accepted/PSR-2-coding-style-guide.md)** - The easiest way to apply the conventions is to install [PHP Code Sniffer](http://pear.php.net/package/PHP_CodeSniffer).

- **Document any change in behaviour** - Make sure the `README.md` and any other relevant documentation are kept up to date.

- **Add tests** - Your patch won't be accepted if it doesn't have tests.

- **Create feature branches** - Pull requests from your master branch won't be accepted.

- **One pull request per feature** - If you want to do more than one thing, create multiple pull requests.

- **Send coherent history** - Make sure each individual commit in your pull request is meaningful. If you had to make multiple intermediate commits while developing, please [squash them](http://www.git-scm.com/book/en/v2/Git-Tools-Rewriting-History#Changing-Multiple-Commit-Messages) before submitting.

