<?php $__env->startSection('title','Users list'); ?>


<?php $__env->startSection('vendor-style'); ?>
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('vendors/data-tables/css/jquery.dataTables.min.css')); ?>">
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('vendors/data-tables/extensions/responsive/css/responsive.dataTables.min.css')); ?>">
<?php $__env->stopSection(); ?>


<?php $__env->startSection('page-style'); ?>
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/pages/page-users.css')); ?>">

<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
<!-- users list start -->
<section class="users-list-wrapper section">
  <div class="card">
    <div class="card-content custom-card">
      <div class="row">
        <div class="col s6">
          <h5 class="page-topic">Users </h5>
          <p class="custom-breadcrumbs">
            <a href="">&nbsp;Home</a> > <a href="">Users </a></p>
        </div>
        <div class="col s6"><a class="waves-effect waves-light purple btn add-btn" href="<?php echo e(asset('page-users-add')); ?>"><i class="material-icons left">add</i>Add User</a></div>

      </div>
    </div>
  </div>
  <div class="users-list-table">
    <div class="card">
      <div class="card-content">
        <!-- datatable start -->
        <div class="responsive-table">
          <table id="users-list-datatable" class="table">
            <thead>
              <tr>
                <th>id</th>
                <th>username</th>
                <th>name</th>
                <th>email</th>
                <th>role</th>
                <th>brands</th>
                <th>status</th>
                <th>action</th>
              </tr>
            </thead>
            <tbody>
            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $us): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <td><?php echo e($us->id); ?></td>
                <td><a href="<?php echo e(asset('page-users-view')); ?>"><?php echo e($us->name); ?></a>
                </td>
                <td><?php echo e($us->good_name); ?></td>
                <td><?php echo e($us->email); ?></td>
                <td>
                <?php
                  $get_role = DB::table('roles')->where('id', $us->role)->first();
                    echo $get_role->name;
                  ?>
                </td>
                <td>
                <?php
                  foreach(explode(',',$us->brands) as $br){

                    $get_name = DB::table('brands')->where('id', $br)->get();
                    foreach($get_name as $gn){
                      echo $gn->name.'<br>';
                    }
                  }
                ?>
                </td>
                <td>
                  <?php if($us->status == 1): ?>
                    <span class="chip green lighten-5">
                      <span class="green-text">Active</span>
                    </span>
                  <?php else: ?>
                    <span class="chip red lighten-5">
                      <span class="red-text">In Active</span>
                    </span>
                  <?php endif; ?>
                </td>

                <td>
                  <a href="<?php echo e(asset('page-users-edit')); ?>/<?php echo e(Crypt::encrypt($us->id)); ?>"><i class="material-icons">edit</i></a>
                  <a href="<?php echo e(asset('page-users-view')); ?>/<?php echo e(Crypt::encrypt($us->id)); ?>"><i class="material-icons">remove_red_eye</i></a>
                </td>
              </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
          </table>
        </div>
        <!-- datatable ends -->
      </div>
    </div>
  </div>
</section>
<!-- users list ends -->
<?php $__env->stopSection(); ?>


<?php $__env->startSection('vendor-script'); ?>
<script src="<?php echo e(asset('vendors/data-tables/js/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(asset('vendors/data-tables/extensions/responsive/js/dataTables.responsive.min.js')); ?>"></script>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('page-script'); ?>
<script src="<?php echo e(asset('js/scripts/page-users.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.contentLayoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/kllk1/pm.kl.lk/pm/resources/views/users/page-users-list.blade.php ENDPATH**/ ?>