<?php $__env->startSection('title','Users edit'); ?>


<?php $__env->startSection('vendor-style'); ?>
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('vendors/select2/select2.min.css')); ?>">
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('vendors/select2/select2-materialize.css')); ?>">
<?php $__env->stopSection(); ?>


<?php $__env->startSection('page-style'); ?>
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/pages/page-users.css')); ?>">
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
<!-- users edit start -->
<div class="section users-edit">
  <div class="card">
    <div class="card-content custom-card">
      <div class="row">
        <div class="col s6">
          <h5 class="page-topic">Edit User </h5>
          <p class="custom-breadcrumbs">
            <a href="">Home</a> > <a href="">Users </a> > <a href=""> Edit User </a></p>
        </div>
      </div>
    </div>
  </div>

  <div class="card">
     <div class="card-content custom-card">
       <div class="row">
         <div class="col s12" id="account">
            <div class="media display-flex align-items-center mb-2">
              <a class="mr-2" href="#">
                <img src="<?php echo e(asset($users->pic)); ?>" alt="users avatar" class="z-depth-4 circle" height="64" width="64">
              </a>
              <div class="media-body">
                <h5 class="media-heading mt-0"><?php echo e($users->good_name); ?></h5>
                
              </div>
            </div>
         </div>
       </div>

       <div class="row">
          <div class="col s12 m12 l12">
            <div id="Form-advance" class="scrollspy">
              <form action="<?php echo e(asset('page-users-update')); ?>/<?php echo e(Crypt::encrypt($users->id)); ?>" enctype="multipart/form-data" method="POST" id="users-edit">
                <?php echo e(csrf_field()); ?>

                <div class="row">
                  <div class="input-field col m6 s12">
                    <label for="uname0">Username*</label>
                    <input class="validate" required id="uname0" name="uname0" type="text" value="<?php echo e($users->name); ?>">
                  </div>
                  <div class="input-field col m6 s12">
                    <label for="cemail0">E-Mail *</label>
                    <input class="validate" required id="email" type="email" name="email" value="<?php echo e($users->email); ?>">
                  </div>
                </div>
                
                <div class="row">
                  <div class="input-field col m6 s12">
                    <label for="name0">Name *</label>
                    <input class="validate" required id="name0" type="text" name="name0" value="<?php echo e($users->good_name); ?>">
                  </div>
                  <div class="input-field col m6 s12">
                    <input type="text" class="datepicker" id="dob" name="dob" value="<?php echo e($users->dob); ?>">
                    <label for="dob">DOB</label>
                  </div>
                </div>
                <div class="row">
                  <div class="input-field col m6 s12">
                    <select id="role" name="role">
                      <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($r->id); ?>"<?php if($users->role == $r->id): ?>selected <?php endif; ?>><?php echo e($r->name); ?></option>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <label>Role</label>
                  </div>
                  <div class="input-field col m6 s12">
                    <select id="status" name="status">
                      <option value="1" <?php if($users->status == 1): ?>selected <?php else: ?> <?php endif; ?>>Active</option>
                      <option value="2" <?php if($users->status == 2): ?>selected <?php else: ?> <?php endif; ?>>Inactive</option>
                    </select>
                    <label>Status</label>
                  </div>
                </div>

                <div class="row">
                  <div class="input-field col m6 s12">
                    <p>Brands *</p>
                    <select class="select2 browser-default" multiple="multiple" id="brands" name="brands[]">
                      <?php $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bd): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($bd->id); ?>" <?php $__currentLoopData = explode(',',$users->brands); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ub): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <?php if($ub == $bd->id): ?>selected <?php else: ?> <?php endif; ?> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>><?php echo e($bd->name); ?></option>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>

                  </div>
                  <div class="col m6 s12 file-field input-field">
                    <br>
                    <div class="btn float-right">
                      <span>Upload profile picture</span>
                      <input type="file" name="file">
                    </div>
                    <div class="file-path-wrapper">
                      <input class="file-path validate" type="text">
                    </div>
                  </div>

                </div>
                <div class="row">
                  <div class="input-field col s12">
                    <button class="btn cyan waves-effect waves-light right" type="submit" name="action">Update
                      <i class="material-icons right">send</i>
                    </button>
                  </div>
                </div>
                </form>
              </div>
            </div>
          </div>
     </div>
  </div>
</div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('vendor-script'); ?>
<script src="<?php echo e(asset('vendors/select2/select2.full.min.js')); ?>"></script>
<script src="<?php echo e(asset('vendors/jquery-validation/jquery.validate.min.js')); ?>"></script>
<script src="<?php echo e(asset('vendors/select2/select2.full.min.js')); ?>"></script>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('page-script'); ?>
<script src="<?php echo e(asset('js/scripts/page-users.js')); ?>"></script>
<script src="<?php echo e(asset('js/scripts/form-select2.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.contentLayoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/kllk1/pm.kl.lk/pm/resources/views/users/page-users-edit.blade.php ENDPATH**/ ?>