<?php $__env->startSection('title','Roles'); ?>


<?php $__env->startSection('vendor-style'); ?>
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('vendors/data-tables/css/jquery.dataTables.min.css')); ?>">
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('vendors/data-tables/extensions/responsive/css/responsive.dataTables.min.css')); ?>">
<?php $__env->stopSection(); ?>


<?php $__env->startSection('page-style'); ?>
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/pages/page-users.css')); ?>">

<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
<!-- users list start -->
<section class="users-list-wrapper section">
  <div class="card">
    <div class="card-content custom-card">
      <div class="row">
        <div class="col s6">
          <h5 class="page-topic">Roles </h5>
          <p class="custom-breadcrumbs">
            <a href="">&nbsp;Home</a> > <a href="">Roles </a></p>
        </div>
        <div class="col s6"><a class="waves-effect waves-light purple btn add-btn" href="<?php echo e(asset('page-roles-create')); ?>"><i class="material-icons left">add</i>Add Role</a></div>

      </div>
    </div>
  </div>
  <div class="users-list-table">
    <div class="card">
      <div class="card-content">
        <!-- datatable start -->
        <?php echo $__env->make('flash-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="responsive-table">
          <table id="roles-list-datatable" class="table">
            <thead>
              <tr>
                <th>id</th>
                <th>code</th>
                <th>name</th>
                <th>status</th>
                <th>action</th>
              </tr>
            </thead>
            <tbody>
            <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bd): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <td><?php echo e($bd->id); ?></td>
                <td><?php echo e($bd->code); ?></td>
                <td><?php echo e($bd->name); ?></td>
                <td>
                    <?php if($bd->status == 1): ?>
                      <span class="chip green lighten-5">
                        <span class="green-text">Active</span>
                      </span>
                    <?php elseif($bd->status == 2): ?>
                      <span class="chip red lighten-5">
                        <span class="red-text">In active</span>
                      </span>
                    <?php endif; ?>
                </td>
                <td>
                  <a href="<?php echo e(asset('page-roles-edit')); ?>/<?php echo e(Crypt::encrypt($bd->id)); ?>"><i class="material-icons">edit</i></a>
                  <a href="<?php echo e(asset('page-roles-delete')); ?>/<?php echo e(Crypt::encrypt($bd->id)); ?>}"><i class="material-icons">delete</i></a>

                </td>
              </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
          </table>
        </div>
        <!-- datatable ends -->
      </div>
    </div>
  </div>
</section>
<!-- users list ends -->
<?php $__env->stopSection(); ?>


<?php $__env->startSection('vendor-script'); ?>
<script src="<?php echo e(asset('vendors/data-tables/js/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(asset('vendors/data-tables/extensions/responsive/js/dataTables.responsive.min.js')); ?>"></script>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('page-script'); ?>
<script src="<?php echo e(asset('js/scripts/page-users.js')); ?>"></script>
<script src="<?php echo e(asset('js/scripts/ui-alerts.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.contentLayoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/kllk1/pm.kl.lk/pm/resources/views/roles/page-roles-list.blade.php ENDPATH**/ ?>