<?php
use App\Http\Controllers\LanguageController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
 */

//Login and Register API
Route::get('user-login', 'AuthController@index');
Route::post('post-login', 'AuthController@postLogin');
Route::get('user-register', 'AuthController@register');
Route::post('post-register', 'AuthController@postRegister');
Auth::routes(['verify' => true]);
Route::middleware(['auth'])->group(function () {
    /*Route::get('/dashboard', ['as' => 'user.dashboard', 'uses' => 'DashboardController@index']);*/

Route::any('download-file/{name}', 'JobController@downloadFile');
Route::any('job-attached-delete/{id}/{job_id}', 'JobController@deleteAttached');
Route::any('page-jobs-client-feedback', 'JobController@clientFeedback');

Route::get('dashboard', 'AuthController@dashboard');
Route::any('filtered-dashboard', 'AuthController@filteredDashboard');
Route::get('logout', 'AuthController@logout');


// Roles Route
Route::get('/page-roles-list', 'RoleController@index');
Route::get('/page-roles-create', 'RoleController@create');
Route::post('/page-roles-store', 'RoleController@store');
Route::get('/page-roles-edit/{id}', 'RoleController@edit');
Route::any('/page-roles-update/{id}', 'RoleController@update');
Route::get('/page-roles-show', 'RoleController@show');
Route::any('/page-roles-delete/{id}', 'RoleController@destroy');

// Brand Route
Route::get('/page-brands-list', 'BrandController@index');
Route::get('/page-brands-create', 'BrandController@create');
Route::post('/page-brands-store', 'BrandController@store');
Route::get('/page-brands-edit/{id}', 'BrandController@edit');
Route::any('/page-brands-update/{id}', 'BrandController@update');
Route::get('/page-brands-show', 'BrandController@show');
Route::any('/page-brands-delete/{id}', 'BrandController@destroy');

// User Route
Route::get('/page-users-list', 'UserController@usersList');
Route::get('/page-users-add', 'UserController@create');
Route::post('/page-users-store', 'UserController@store');
Route::get('/page-users-edit/{id}', 'UserController@edit');
Route::any('/page-users-update/{id}', 'UserController@update');
Route::get('/page-users-view/{id}', 'UserController@show');

// Job Route
Route::get('/page-jobs-list', 'JobController@index');
Route::get('/page-jobs-create', 'JobController@create');
Route::post('/page-jobs-store', 'JobController@store');
Route::get('/page-jobs-edit/{id}', 'JobController@edit');
Route::any('/page-jobs-update/{id}', 'JobController@update');
Route::get('/page-jobs-show/{id}', 'JobController@show');
Route::any('/page-jobs-delete/{id}', 'JobController@destroy');
Route::any('/page-jobs-view-update/{id}', 'JobController@viewUpdate');
Route::any('/page-jobs-clone/{id}', 'JobController@clone');

// Image Routes
Route::get('/image-view','ImageController@index');
Route::post('/image-store/{id}','ImageController@store');

//Comment routes
Route::post('/comment/store', 'CommentController@store')->name('comment.add');
Route::post('/reply/store', 'CommentController@replyStore')->name('reply.add');

// Dashboard Route
Route::get('/', 'DashboardController@dashboardModern');
Route::get('/modern', 'DashboardController@dashboardModern');
Route::get('/ecommerce', 'DashboardController@dashboardEcommerce');
Route::get('/analytics', 'DashboardController@dashboardAnalytics');
});


// User profile Route
Route::get('/user-profile-page', 'UserProfileController@userProfile');


Route::get('/home', 'HomeController@index')->name('home');
