{{-- layout --}}
@extends('layouts.contentLayoutMaster')

{{-- page title --}}
@section('title','Users View')

{{-- page style --}}
@section('page-style')
<link rel="stylesheet" type="text/css" href="{{asset('css/pages/page-users.css')}}">
@endsection

{{-- page content  --}}
@section('content')
<!-- users view start -->
<div class="section users-view">
  <!-- users view media object start -->
  <div class="card-panel">
    <div class="row">
      <div class="col s12 m7">
        <div class="display-flex media">
          <a href="#" class="avatar">
            <img src="{{asset($users->pic)}}" alt="users view avatar" class="z-depth-4 circle"
              height="64" width="64">
          </a>
          <div class="media-body">
            <h6 class="media-heading">
              <span class="users-view-name">{{ $users->good_name }} </span>
              <span class="grey-text">@</span>
              <span class="users-view-username grey-text">{{ $users->name }}</span>
            </h6>
          </div>
        </div>
      </div>
      {{--<div class="col s12 m5 quick-action-btns display-flex justify-content-end align-items-center pt-2">
        <a href="{{asset('page-users-edit')}}" class="btn-small indigo">Edit</a>
      </div>--}}
    </div>
  </div>
  <!-- users view media object ends -->
  <!-- users view card data start -->
  <div class="card">
    <div class="card-content">
      <div class="row">
        <div class="col s12 m4">
          <table class="striped">
            <tbody>
              <tr>
                <td>Email : </td>
                <td>{{ $users->email }}</td>
              </tr>
              <tr>
                <td>Date of Birth :</td>
                <td class="users-view-latest-activity">{{ $users->dob }}</td>
              </tr>
              <tr>
                <td>Brands :</td>
                <td class="users-view-verified">
                  <?php
                  foreach(explode(',',$users->brands) as $br){

                    $get_name = DB::table('brands')->where('id', $br)->get();
                    foreach($get_name as $gn){
                      echo $gn->name.', ';
                    }
                  }
                  ?>

                </td>
              </tr>
              <tr>
                <td>Role :</td>
                <td class="users-view-role">
                  @foreach($users->roles as $ro)
                    {{ $ro->name }}
                  @endforeach
                </td>
              </tr>
              <tr>
                <td>Status :</td>
                <td>
                  @if($users->status == 1)
                    <span class=" users-view-status chip green lighten-5 green-text">Active</span>
                  @else
                    <span class=" users-view-status chip red lighten-5 red-text">In Active</span>
                  @endif
                </td>
              </tr>
            </tbody>
          </table>
        </div>
        {{--<div class="col s12 m8">
          <table class="responsive-table">
            <thead>
              <tr>
                <th>Module Permission</th>
                <th>Read</th>
                <th>Write</th>
                <th>Create</th>
                <th>Delete</th>
              </tr>
            </thead>
            <tbody>
              <tr>
                <td>Users</td>
                <td>Yes</td>
                <td>No</td>
                <td>No</td>
                <td>Yes</td>
              </tr>
              <tr>
                <td>Articles</td>
                <td>No</td>
                <td>Yes</td>
                <td>No</td>
                <td>Yes</td>
              </tr>
              <tr>
                <td>Staff</td>
                <td>Yes</td>
                <td>Yes</td>
                <td>No</td>
                <td>No</td>
              </tr>
            </tbody>
          </table>
        </div>--}}
      </div>
    </div>
  </div>
  <!-- users view card data ends -->


</div>
<!-- users view ends -->
@endsection

{{-- page script --}}
@section('page-script')
<script src="{{asset('js/scripts/page-users.js')}}"></script>
@endsection