{{-- layout --}}
@extends('layouts.contentLayoutMaster')

{{-- page title --}}
@section('title','Users list')

{{-- vendors styles --}}
@section('vendor-style')
<link rel="stylesheet" type="text/css" href="{{asset('vendors/data-tables/css/jquery.dataTables.min.css')}}">
<link rel="stylesheet" type="text/css" href="{{asset('vendors/data-tables/extensions/responsive/css/responsive.dataTables.min.css')}}">
@endsection

{{-- page styles --}}
@section('page-style')
<link rel="stylesheet" type="text/css" href="{{asset('css/pages/page-users.css')}}">

@endsection

{{-- page content --}}
@section('content')
<!-- users list start -->
<section class="users-list-wrapper section">
  <div class="card">
    <div class="card-content custom-card">
      <div class="row">
        <div class="col s6">
          <h5 class="page-topic">Users </h5>
          <p class="custom-breadcrumbs">
            <a href="">&nbsp;Home</a> > <a href="">Users </a></p>
        </div>
        <div class="col s6"><a class="waves-effect waves-light purple btn add-btn" href="{{asset('page-users-add')}}"><i class="material-icons left">add</i>Add User</a></div>

      </div>
    </div>
  </div>
  <div class="users-list-table">
    <div class="card">
      <div class="card-content">
        <!-- datatable start -->
        <div class="responsive-table">
          <table id="users-list-datatable" class="table">
            <thead>
              <tr>
                <th>id</th>
                <th>username</th>
                <th>name</th>
                <th>email</th>
                <th>role</th>
                <th>brands</th>
                <th>status</th>
                <th>action</th>
              </tr>
            </thead>
            <tbody>
            @foreach($users as $us)
              <tr>
                <td>{{$us->id}}</td>
                <td><a href="{{asset('page-users-view')}}">{{$us->name}}</a>
                </td>
                <td>{{ $us->good_name }}</td>
                <td>{{ $us->email }}</td>
                <td>
                <?php
                  $get_role = DB::table('roles')->where('id', $us->role)->first();
                    echo $get_role->name;
                  ?>
                </td>
                <td>
                <?php
                  foreach(explode(',',$us->brands) as $br){

                    $get_name = DB::table('brands')->where('id', $br)->get();
                    foreach($get_name as $gn){
                      echo $gn->name.'<br>';
                    }
                  }
                ?>
                </td>
                <td>
                  @if($us->status == 1)
                    <span class="chip green lighten-5">
                      <span class="green-text">Active</span>
                    </span>
                  @else
                    <span class="chip red lighten-5">
                      <span class="red-text">In Active</span>
                    </span>
                  @endif
                </td>

                <td>
                  <a href="{{asset('page-users-edit')}}/{{Crypt::encrypt($us->id)}}"><i class="material-icons">edit</i></a>
                  <a href="{{asset('page-users-view')}}/{{Crypt::encrypt($us->id)}}"><i class="material-icons">remove_red_eye</i></a>
                </td>
              </tr>
            @endforeach
            </tbody>
          </table>
        </div>
        <!-- datatable ends -->
      </div>
    </div>
  </div>
</section>
<!-- users list ends -->
@endsection

{{-- vendor scripts --}}
@section('vendor-script')
<script src="{{asset('vendors/data-tables/js/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('vendors/data-tables/extensions/responsive/js/dataTables.responsive.min.js')}}"></script>
@endsection

{{-- page script --}}
@section('page-script')
<script src="{{asset('js/scripts/page-users.js')}}"></script>
@endsection