{{-- layout --}}
@extends('layouts.contentLayoutMaster')

{{-- page title --}}
@section('title','Users edit')

{{-- vendor styles --}}
@section('vendor-style')
<link rel="stylesheet" type="text/css" href="{{asset('vendors/select2/select2.min.css')}}">
<link rel="stylesheet" type="text/css" href="{{asset('vendors/select2/select2-materialize.css')}}">
@endsection

{{-- page style --}}
@section('page-style')
<link rel="stylesheet" type="text/css" href="{{asset('css/pages/page-users.css')}}">
<link rel="stylesheet" type="text/css" href="{{asset('css/pages/form-select2.css')}}">
@endsection

{{-- page content --}}
@section('content')
<!-- users edit start -->
<div class="section users-edit">
  <div class="card">
    <div class="card-content custom-card">
      <div class="row">
        <div class="col s6">
          <h5 class="page-topic">Add Users </h5>
          <p class="custom-breadcrumbs">
            <a href="">Home</a> > <a href="">Users </a> > <a href=""> Add Users </a></p>
        </div>
      </div>
    </div>
  </div>

  <div class="card">
    <div class="row">
        <div class="col s12 m12 l12">
          <div id="Form-advance" class="scrollspy">
            <div class="card-content">
              <form action="{{ asset('page-users-store') }}" method="POST" enctype="multipart/form-data" id="user-add">
                {{  csrf_field() }}
                <div class="row">
                  <div class="input-field col m6 s12">
                    <label for="uname0">Username*</label>
                    <input class="validate" required id="uname0" name="uname0" type="text" value="">
                  </div>
                  <div class="input-field col m6 s12">
                    <label for="cemail0">E-Mail *</label>
                    <input class="validate" required id="email" type="email" name="email" value="">
                  </div>
                </div>
                <div class="row">
                  <div class="input-field col m6 s12">
                    <label for="password0">Password *</label>
                    <input class="validate" required id="password0" type="password" name="password0" value="">
                  </div>
                  <div class="input-field col m6 s12">
                    <label for="cpassword0">Confirm Password *</label>
                    <input class="validate" required id="cpassword0" type="password" name="cpassword0" value="">
                  </div>
                </div>
                <div class="row">
                  <div class="input-field col m6 s12">
                    <label for="name0">Name *</label>
                    <input class="validate" required id="name0" type="text" name="name0" value="">
                  </div>
                  <div class="input-field col m6 s12">
                    <input type="text" class="datepicker" id="dob" name="dob" value="">
                    <label for="dob">DOB</label>
                  </div>
                </div>
                <div class="row">
                  <div class="input-field col m6 s12">
                    <select id="role" name="role">
                      @foreach($roles as $r)
                        <option value="{{$r->id}}">{{$r->name}}</option>
                      @endforeach
                    </select>
                    <label>Role</label>
                  </div>
                  <div class="input-field col m6 s12">
                    <select id="status" name="status">
                      <option value="1">Active</option>
                      <option value="2">Inactive</option>
                    </select>
                    <label>Status</label>
                  </div>
                </div>

                <div class="row">
                  <div class="input-field col m6 s12">
                    <p>Brands</p>
                    <select class="select2 browser-default" multiple="multiple" id="brands" name="brands[]">
                      @foreach($brands as $bd)
                          <option value="{{$bd->id}}">{{$bd->name}}</option>
                      @endforeach
                    </select>

                  </div>
                  <div class="col m6 s12 file-field input-field">
                    <div class="btn float-right">
                      <span>Upload profile picture</span>
                      <input type="file" name="file">
                    </div>
                    <div class="file-path-wrapper">
                      <input class="file-path validate" type="text">
                    </div>
                  </div>

                </div>
                <div class="row">
                  <div class="input-field col s12">
                    <button class="btn cyan waves-effect waves-light right" type="submit" name="action">Submit
                      <i class="material-icons right">send</i>
                    </button>
                  </div>
                </div>
              </form>
            </div>
          </div>
        </div>
      </div>
    </div>
</div>
<!-- users edit ends -->
@endsection

{{-- vendor scripts --}}
@section('vendor-script')
<script src="{{asset('vendors/select2/select2.full.min.js')}}"></script>
<script src="{{asset('vendors/jquery-validation/jquery.validate.min.js')}}"></script>
<script src="{{asset('vendors/select2/select2.full.min.js')}}"></script>
@endsection

{{-- page scripts --}}
@section('page-script')
<script src="{{asset('js/scripts/page-users.js')}}"></script>
<script src="{{asset('js/scripts/form-select2.js')}}"></script>
@endsection
