{{-- layout extend --}}
@extends('layouts.contentLayoutMaster')

{{-- page title --}}
{{--@section('title','Dashboard')--}}

{{-- vendor styles --}}
@section('vendor-style')
<link rel="stylesheet" type="text/css" href="{{asset('vendors/animate-css/animate.css')}}">
<link rel="stylesheet" type="text/css" href="{{asset('vendors/chartist-js/chartist.min.css')}}">
<link rel="stylesheet" type="text/css" href="{{asset('vendors/chartist-js/chartist-plugin-tooltip.css')}}">

<link rel="stylesheet" type="text/css" href="{{asset('vendors/data-tables/css/jquery.dataTables.min.css')}}">
<link rel="stylesheet" type="text/css" href="{{asset('vendors/data-tables/extensions/responsive/css/responsive.dataTables.min.css')}}">
<link rel="stylesheet" type="text/css" href="{{asset('vendors/data-tables/css/select.dataTables.min.css')}}">
@endsection

{{-- page styles --}}
@section('page-style')
<link rel="stylesheet" type="text/css" href="{{asset('css/pages/dashboard-modern.css')}}">
<link rel="stylesheet" type="text/css" href="{{asset('css/pages/intro.css')}}">
<link rel="stylesheet" type="text/css" href="{{asset('css/pages/data-tables.css')}}">
   <style>
      #main .section-data-tables .dataTables_wrapper table.dataTable tbody td:not(:first-child) {
         padding: 2px 4px !important;
      }
      
     .navbar .header-search-wrapper{
         display:none !important;
     }
   </style>
@endsection

{{-- page content --}}
@section('content')

   <div id="card-stats" class="pt-0">
      <div class="row">
         <div class="col s12 m6 l6 xl3">
            <div class="card gradient-45deg-light-blue-cyan gradient-shadow min-height-100 white-text animate fadeLeft">
               <div class="padding-4">
                  <div class="row">
                     <div class="col s7 m7">
                        <i class="material-icons background-round mt-5">timeline</i>
                     </div>
                     <div class="col s5 m5 right-align">
                        <h5 class="mb-0 white-text">{{ $assigned ?? '' }}</h5>
                        <p class="no-margin">Assigned</p>
                     </div>
                  </div>
               </div>
            </div>
         </div>
         <div class="col s12 m6 l6 xl3">
            <div class="card gradient-45deg-red-pink gradient-shadow min-height-100 white-text animate fadeLeft">
               <div class="padding-4">
                  <div class="row">
                     <div class="col s7 m7">
                        <i class="material-icons background-round mt-5">timeline</i>
                     </div>
                     <div class="col s5 m5 right-align">
                        <h5 class="mb-0 white-text">{{ $pending ?? '' }}</h5>
                        <p class="no-margin">Pending</p>
                     </div>
                  </div>
               </div>
            </div>
         </div>
         <div class="col s12 m6 l6 xl3">
            <div class="card gradient-45deg-amber-amber gradient-shadow min-height-100 white-text animate fadeRight">
               <div class="padding-4">
                  <div class="row">
                     <div class="col s6 m6">
                        <i class="material-icons background-round mt-5">timeline</i>
                     </div>
                     <div class="col s6 m6 right-align">
                        <h5 class="mb-0 white-text">{{ $completed }}</h5>
                        <p class="no-margin">Completed</p>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>

   <div class="row">
      <form action="{{asset('filtered-dashboard')}}" enctype="multipart/form-data"  method="POST" id="filtering">
         {{ csrf_field() }}
         <div class="input-field col m2 s8" style="@if($role == 1 || $role == 2 || $role == 6) display:block !important; @else display:none !important; @endif">
            <p for="status"><b>Status</b></p>
            <select class="select2 browser-default status-of-job" id="status" name="status">
               <option value="0">Select Status</option>
               <option value="1">Approval Pending</option>
               <option value="2">Account Manger job Created</option>
               <option value="3">Strategy In Progress</option>
               <option value="4">Strategy Job Done</option>
               <option value="5">Copy Writer In Progress</option>
               <option value="6">Copy Writer Job Done</option>
               <option value="7">Designer In Progress</option>
               <option value="8">Designer Job Done</option>
               <option value="9">Media In Progress</option>
               <option value="10">Media Job Done</option>
               <option value="11">Delivered</option>
            </select>
         </div>
         <div class="input-field col m2 s8">
            <p for="status"><b>Brands</b></p>
            <select class="select2 browser-default user-id" id="brand" name="brand">
               <option value="0">Select brand</option>
               @foreach($brands as $br)
                  <option value="{{ $br->id }}">{{ $br->name }}</option>
               @endforeach
            </select>
         </div>


         <div class="input-field col m2 s8" style="@if($role == 1  || $role == 6) display:block !important; @else display:none !important; @endif">
            <p for="status"><b>Users</b> </p>
            <select class="select2 browser-default user-id" id="user" name="user">
               <option value="0">Select user</option>
               @foreach($all_users as $al)
                  <option value="{{ $al->id }}" @if($al->id == $auth_user_id) selected @endif> {{ $al->name }}</option>
               @endforeach
            </select>
         </div>

        <div class="input-field col m2 s8" style="@if($role == 1  || $role == 6) display:block !important; @else display:none !important; @endif">
            <p for="status"><b>Final Status</b> </p>
            <select class="select2 browser-default user-id" id="fstatus" name="fstatus">
               <option value="">Select Status</option>
               <option value="0">Pending</option>
               <option value="1">Approved</option>
               <option value="2">Revisions</option>
            </select>
         </div>
         
         <div class="input-field col m3 s6">
            <p for="blank">&nbsp; </p>
            <button class="btn cyan waves-effect waves-light left" type="submit" name="action">Filter
            </button>
         </div>
      </form>
   </div>

<div class="section section-data-tables">
   <!-- Current balance & total transactions cards-->
   <div class="row">
      <div class="col s12">
         <div class="card">
            <div class="card-content">
               <h4 class="card-title">Job List
                  @if(Auth::user()->role == 1 || Auth::user()->role == 2 || Auth::user()->role == 6)<a class="waves-effect waves-light purple btn add-btn" href="{{asset('page-jobs-create')}}" style="float: right !important;"><i class="material-icons left">add</i>Add Job</a>@endif
               </h4>
               <br>
               <div class="row">
                  <div class="col s12">
                     <table id="page-length-option" class="display table-responsive new-dash-table">
                        <thead>
                           <tr>
                              <th>Date</th>
                              <th>Job no</th>
                              <th>Product</th>
                              <th>Status</th>
                              <th>Deadline</th>
                              @if(Auth::user()->role == 1 ||Auth::user()->role == 2 || Auth::user()->role == 9)<th>Final Status</th>@endif
                              <th>Action</th>
                           </tr>
                        </thead>
                        <tbody>
                        @if(!empty($jobs))
                         @foreach($jobs as $jb)
                           <tr>
                              <td>{{ date('Y-m-d', strtotime($jb->created_at)) }}</td>
                              <td>{{ $jb->job_no }}</td>

                              <td style="white-space: break-spaces; min-width: 180px;">{{ $jb->product }}</td>
                              <td>
                                 @if($jb->status == 1) Approval Pending
                                    @elseif($jb->status == 2) Job Created - Account Management
                                    @elseif($jb->status == 3) Strategy In Progress
                                    @elseif($jb->status == 4) Strategy Job Completed
                                    @elseif($jb->status == 5) Copy Writer In Progress
                                    @elseif($jb->status == 6) Copy Writer Job Completed
                                    @elseif($jb->status == 7) Art Director In Progress
                                    @elseif($jb->status == 8) Art Director Job Completed
                                    @elseif($jb->status == 9) Sent to Client
                                    @elseif($jb->status == 10) TVC Production
                                    @elseif($jb->status == 11) Media
                                    @elseif($jb->status == 12) Delivered
                                 @endif
                              </td>
                              <td>{{ $jb->deadline }}</td>
                              @if((Auth::user()->role == 1 || Auth::user()->role == 2 ||  Auth::user()->role == 9))
                                 <td>
                                    <select class="select2 browser-default client-feedback" id="client-feedback" name="client-feedback" data-jobid="{{ $jb->id }}">
                                       @if($jb->status == 9)
                                       <option value="0" >Pending</option>
                                       <option value="1" @if($jb->cl_feedback == 1) selected @endif>Approved</option>
                                       <option value="2" @if($jb->cl_feedback == 2) selected @endif>Revisions</option>
                                          @else
                                          <option value="0" >-------</option>
                                       @endif
                                    </select>
                                 </td>
                              @endif
                            {{--@if(Auth::user()->role == 9 && $jb->status == 9)
                                 <td>
                                    <select class="select2 browser-default client-feedback-cl" id="client-feedback-cl" name="client-feedback-cl" data-jobid="{{ $jb->id }}">
                                       <option value="0">Pending</option>
                                       <option value="1" @if($jb->cl_feedback == 1) selected @endif>Approved</option>
                                       <option value="2" @if($jb->cl_feedback == 2) selected @endif>Revisions</option>
                                    </select>
                                 </td>
                              @endif--}}
                              <td>&nbsp;&nbsp;
                                  @if((Auth::user()->role == 1 || Auth::user()->role == 2) && $jb->cl_feedback == 2)<a href="{{asset('page-jobs-clone')}}/{{Crypt::encrypt($jb->id)}}"><i class="material-icons">autorenew</i></a>@endif

                              @if(Auth::user()->role == 1 || Auth::user()->role == 2 || Auth::user()->role == 6) <a href="{{asset('page-jobs-edit')}}/{{Crypt::encrypt($jb->id)}}"><i class="material-icons">edit</i></a>@endif
                                 <a href="{{asset('page-jobs-show')}}/{{Crypt::encrypt($jb->id)}}"><i class="material-icons">remove_red_eye</i></a>

                                 @if(Auth::user()->role == 1 || Auth::user()->role == 2 || Auth::user()->role == 6)<a href="{{asset('page-jobs-delete')}}/{{Crypt::encrypt($jb->id)}}"><i class="material-icons">delete</i></a>@endif
                              </td>
                           </tr>
                         @endforeach
                        @endif
                        </tbody>
                     </table>
                  </div>
               </div>
         </div>
      </div>
   </div>
</div>
{{--@include('pages.intro')--}}
@endsection

{{-- vendor scripts --}}
@section('vendor-script')
<script src="{{asset('vendors/chartjs/chart.min.js')}}"></script>
<script src="{{asset('vendors/chartist-js/chartist.min.js')}}"></script>
{{--
<script src="{{asset('vendors/chartist-js/chartist-plugin-tooltip.js')}}"></script>
--}}
<script src="{{asset('vendors/chartist-js/chartist-plugin-fill-donut.min.js')}}"></script>

<script src="{{asset('vendors/data-tables/js/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('vendors/data-tables/extensions/responsive/js/dataTables.responsive.min.js')}}"></script>
<script src="{{asset('vendors/data-tables/js/dataTables.select.min.js')}}"></script>
@endsection

{{-- page scripts --}}
@section('page-script')
<script src="{{asset('js/scripts/dashboard-modern.js')}}"></script>
<script src="{{asset('js/scripts/intro.js')}}"></script>
<script src="{{asset('js/scripts/data-tables.js')}}"></script>

<script>
   $('.client-feedback').change(function () {
      var id = $(this).val();
      var jobid = $(this).attr("data-jobid");

      console.log(id);
      console.log(jobid);
      $.ajax({
         type: "POST",
         url: '{{action('JobController@clientFeedback')}}',
         data: {"_token": "{{ csrf_token() }}",'id': id, 'jobid':jobid}

      }).done(function (msg) {
          location.reload();
      });
   });
   </script>
   <script>
   $('.client-feedback-cl').change(function () {
       var id = $(this).val();
       var jobid = $(this).attr("data-jobid");

       $.ajax({
           type: "POST",
           url: '{{action('JobController@clientFeedback')}}',
           data: {"_token": "{{ csrf_token() }}",'id': id, 'jobid':jobid}

       }).done(function (msg) {
           location.reload();
       });
   });
</script>
@endsection