{{-- layout --}}
@extends('layouts.contentLayoutMaster')

{{-- page title --}}
@section('title','Users View')

{{-- page style --}}
@section('page-style')
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-fileinput/4.4.7/css/fileinput.css" media="all" rel="stylesheet" type="text/css"/>

    <link rel="stylesheet" type="text/css" href="{{asset('css/pages/page-users.css')}}">
<style>
  .display-comment .display-comment {
    margin-left: 40px
  }

  th{
      padding-top: 0px !important;
      padding-bottom: 0px !important;
  }

  td{
    padding-top: 5px !important;
    padding-bottom: 0px !important;
  }

    .completed{
        text-align: center !important;
        width: 30% !important;
        height: auto !important;
    }
    
    .fileinput-upload-button{
        display: none !important;
    }
</style>
@endsection

{{-- page content  --}}
@section('content')
<!-- users view start -->
<div class="section users-view">
  <!-- users view media object start -->
  <div class="card-panel">
    <div class="row">
      <div class="col s12 m7">
        <div class="display-flex media">
          <div class="media-body">
            <h6 class="media-heading">
              <span class="users-view-name">{{ $get_job_details->job_no }}  - {{ $get_job_details->product }}</span>
            </h6>
            <span class="users-view-id"><b>Deadline - {{ $get_job_details->deadline }}</b> </span>
          </div>
        </div>
      </div>
      <div class="col s12 m5 justify-content-end ">
        <p style="margin-top: 5px; margin-bottom: 0px;"><b>Brand : @foreach($brands as $br){{ $br->name }} @endforeach </b></p>
        <p style="margin-top: 5px; margin-bottom: 0px;"><b>Client : {{ $client }}  </b></p>

      </div>
    </div>
  </div>
  <!-- users view media object ends -->
  <!-- users view card data start -->
  <div class="card">
    <div class="card-content">
      <div class="row indigo lighten-5 border-radius-4 mb-2">
        <div class="col s12 m12 users-view-timeline">
        {{--  <p class="indigo-text m-0"></p>--}}
          <div class="row">
              <form action="{{asset('page-jobs-view-update')}}/{{Crypt::encrypt($get_job_details->id)}}" enctype="multipart/form-data" method="POST" id="jobs-edit">
                  {{ csrf_field() }}
                    <div class="input-field col s8 m8">
                      <h6 for="status"><b>Team & Number of sub tasks completed</b></h6>
                      <br>
                      <table class="job-view-table" style="border-collapse: unset !important;">
                        <thead>
                        <tr>
                          <th></th>
                          <th style="width: 30%; padding-left: 10px;">Role</th>
                          <th>Team members</th>
                          <th>Completed</th>
                        </tr>
                        </thead>
                        <tbody>
                        <tr>
                          <td>1</td>
                          <td>Strategy</td>
                          <td>{{$strategy}}</td>
                          <td><input type="number" name="str" value="{{$get_job_details->str}}" class="completed" @if($get_user_role == 9) disabled @endif></td>
                        </tr>
                        <tr>
                          <td>2</td>
                          <td>Copy Writer</td>
                          <td>{{$copy}}</td>
                          <td><input type="number" name="cw" value="{{$get_job_details->cw}}" class="completed" @if($get_user_role == 9) disabled @endif></td>

                        </tr>
                        <tr>
                          <td>3</td>
                          <td>Designer</td>
                          <td>{{$designer}}</td>
                          <td><input type="number" name="des" value="{{$get_job_details->des}}" class="completed" @if($get_user_role == 9) disabled @endif></td>
                        </tr>
                        <tr>
                          <td>4</td>
                          <td>Head of Creative</td>
                          <td>{{$art}}</td>
                          <td><input type="number" name="hoc" value="{{$get_job_details->hoc}}" class="completed" @if($get_user_role == 9) disabled @endif></td>
                        </tr>
                        <tr>
                          <td>5</td>
                          <td>Media Manager</td>
                          <td>{{$media}}</td>
                          <td><input type="number" name="mm" value="{{$get_job_details->mm}}" class="completed" @if($get_user_role == 9) disabled @endif></td>
                        </tr>

                        </tbody>
                      </table>
                    </div>

                    <div class="input-field col s4 m4">
                        <h6><b>Job Status</b></h6>
                        <br>
                        <select class="select2 browser-default" id="status" name="status" @if($get_user_role == 9) disabled @endif>
                            <option value="1" @if($get_job_details->status == 1) selected @endif>Approval Pending</option>
                            <option value="2" @if($get_job_details->status == 2) selected @endif>Job Created - Account Management</option>
                            <option value="3" @if($get_job_details->status == 3) selected @endif>Strategy In Progress</option>
                            <option value="4" @if($get_job_details->status == 4) selected @endif>Strategy Job Completed</option>
                            <option value="5" @if($get_job_details->status == 5) selected @endif>Copy Writer In Progress</option>
                            <option value="6" @if($get_job_details->status == 6) selected @endif>Copy Writer Job Completed</option>
                            <option value="7" @if($get_job_details->status == 7) selected @endif>Art Director In Progress</option>
                            <option value="8" @if($get_job_details->status == 8) selected @endif>Art Director Job Completed</option>
                            <option value="9" @if($get_job_details->status == 9) selected @endif>Sent to Client</option>
                            <option value="10" @if($get_job_details->status == 10) selected @endif>TVC Production</option>
                            <option value="11" @if($get_job_details->status == 11) selected @endif>Media</option>
                            <option value="12" @if($get_job_details->status == 12) selected @endif>Delivered</option>
                        </select>
                        <br>

                        <h6><b>Related Manager </b></h6> <br>
                        <p>@if(!empty($manager)){{ $manager->name }} @else Not Available @endif</p>

                        <br>

                        @if($get_user_role != 9)
                        <button class="btn waves-effect waves-light left" type="submit" name="action">Update</button>
                        @endif
                    </div>
              </form>
          </div>
        </div>
       {{-- <div class="col s12 m4 users-view-timeline">
          <p class="indigo-text m-0"><b>Assigned to:</b> <span>@foreach($assigners as $as){{ $as->name }}, @endforeach</span></p>
        </div>--}}

      </div>
      <div class="row">
        <div class="col s12 m12">
          <p>{{ $get_job_details->description }}</p>
          <br>
            <div class="input-field col s12">
               
                    @if(count($attached)> 0)
                        @foreach($attached as $at)
                            <?php
                                $finfo = finfo_open(FILEINFO_MIME_TYPE);
                                $type = finfo_file($finfo, "upload/$at->attached");
                                
                                if (isset($type) && in_array($type, array("image/png", "image/jpeg", "image/gif"))) {
                                    $image = 1;
                                } else {
                                     $image = 0;
                                }
    
                            ?>
                            @if($image == 1)
                                <img src="{{asset('upload')}}/{{$at->attached}}" style="max-width: 200px; max-height:250px;">
                                <a href="{{asset('download-file')}}/{{ $at->attached }}"><i class="material-icons">arrow_downward</i></a>&nbsp;&nbsp;
                            @else
                                <iframe src="{{asset('upload')}}/doc_image.png" height="150" width="150"></iframe>
                                 <a href="{{asset('download-file')}}/{{ $at->attached }}"><i class="material-icons">arrow_downward</i></a>&nbsp;&nbsp;

                            @endif
                        @endforeach
                    @endif
            </div>
        </div>
      </div>
    </div>
  </div>
  <!-- users view card data ends -->

  <!-- users view card details start -->
  <div class="card">
    <div class="card-content">
      <div class="row">

        <h5>Comments</h5><br>
        
        @foreach($get_job_details->comments as $comment)
        @if(Auth::user()->role != 9)
          <div class="display-comment">
            <h6><b>{{ $comment->user->name }}</b></h6>
              <p>
              @if(count($comments_attached) > 0)
                  @foreach($comments_attached as $ca)
                      @if($comment->id == $ca->post_id)
                            <?php
                                $finfo = finfo_open(FILEINFO_MIME_TYPE);
                                $type = finfo_file($finfo, "upload/$ca->comment_file");
                                
                                if (isset($type) && in_array($type, array("image/png", "image/jpeg", "image/gif"))) {
                                    $image = 1;
                                } else {
                                     $image = 0;
                                }
    
                            ?>
                            @if($image == 1)
                                <img src="{{asset('upload')}}/{{$ca->comment_file}}" style="max-width: 200px; max-height:250px;">
                                <a href="{{asset('download-file')}}/{{ $ca->comment_file }}"><i class="material-icons">arrow_downward</i></a>&nbsp;&nbsp;
                            @else
                                <iframe src="{{asset('upload')}}/doc_image.png" height="100" width="100">{{asset('upload')}}/doc_image.png"</iframe>
                                <a href="{{asset('download-file')}}/{{ $ca->comment_file }}"><i class="material-icons">arrow_downward</i></a>&nbsp;&nbsp;
                            @endif
                            
                         {{--<img src="{{asset('upload')}}/{{$ca->comment_file}}" style="max-width: 200px; max-height:250px;">
                         <a href="{{asset('download-file')}}/{{ $ca->comment_file }}"><i class="material-icons">arrow_downward</i></a>--}}&nbsp;&nbsp;&nbsp;
                      @endif
                  @endforeach
              @endif<br>
            {{ $comment->body }}</p>
          </div>
              <br>
        @endif
        @endforeach
{{--
        @include('jobs.comment-replies', ['comments' => $get_job_details->comments, 'post_id' => $get_job_details->id])
--}}
        <br>
        <h5>Add comment</h5>
        <form method="post" action="{{ route('comment.add') }}" enctype="multipart/form-data">
          {{ csrf_field() }}
          <div class="form-group">
            <input type="text" name="comment_body" class="form-control" />
            <input type="hidden" name="post_id" value="{{ $get_job_details->id }}" />
              <div class="file-loading">
                  <input id="file" type="file" name="file[]" multiple class="file" data-overwrite-initial="false">
              </div>
          </div>
            <br>
          <div class="form-group">
            <input type="submit" class="btn btn-warning" value="Add Comment" />
          </div>
        </form>
      </div>
      <!-- </div> -->
    </div>
  </div>
  <!-- users view card details ends -->

</div>
<!-- users view ends -->
@endsection

{{-- page script --}}
@section('page-script')
<script src="{{asset('js/scripts/page-users.js')}}"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-fileinput/4.4.7/js/fileinput.js" type="text/javascript"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-fileinput/4.4.7/themes/fa/theme.js" type="text/javascript"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.11.0/umd/popper.min.js" type="text/javascript"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0-beta/js/bootstrap.min.js" type="text/javascript"></script>
@endsection