{{-- layout --}}
@extends('layouts.contentLayoutMaster')

{{-- page title --}}
@section('title','Jobs')

{{-- vendors styles --}}
@section('vendor-style')
<link rel="stylesheet" type="text/css" href="{{asset('vendors/data-tables/css/jquery.dataTables.min.css')}}">
<link rel="stylesheet" type="text/css" href="{{asset('vendors/data-tables/extensions/responsive/css/responsive.dataTables.min.css')}}">
@endsection

{{-- page styles --}}
@section('page-style')
<link rel="stylesheet" type="text/css" href="{{asset('css/pages/page-users.css')}}">

@endsection

{{-- page content --}}
@section('content')
<!-- users list start -->
<section class="users-list-wrapper section">
  <div class="card">
    <div class="card-content custom-card">
      <div class="row">
        <div class="col s6">
          <h5 class="page-topic">Jobs </h5>
          <p class="custom-breadcrumbs">
            <a href="">&nbsp;Home</a> > <a href="">Jobs </a></p>
        </div>
        <div class="col s6"><a class="waves-effect waves-light purple btn add-btn" href="{{asset('page-jobs-create')}}"><i class="material-icons left">add</i>Add Job</a></div>

      </div>
    </div>
  </div>
  <div class="users-list-table">
    <div class="card">
      <div class="card-content">
        <!-- datatable start -->
        @include('flash-message')
        <div class="responsive-table">
          <table id="page-length-option" class="table">
            <thead>
              <tr>
                <th>id</th>
                <th>date</th>
                <th>job no</th>
                <th>product</th>
                <th>created by</th>
                <th>brand</th>
                <th>deadline</th>
                <th>status</th>
                <th>action</th>
              </tr>
            </thead>
            <tbody>
            @foreach($jobs as $bd)
              <tr>
                <td>{{ $bd->id }}</td>
                <td>{{ date("Y-m-d", strtotime($bd->created_at)) }}</td>
                <td>{{ $bd->job_no }}</td>
                <td>{{ $bd->product }}</td>
                <td>{{ $bd->created_by }}</td>
                <td>
                  <?php
                  foreach(explode(',',$bd->brand) as $br){

                    $get_name = DB::table('brands')->where('id', $br)->get();
                    foreach($get_name as $gn){
                      echo $gn->name.'<br>';
                    }
                  }
                  ?>

                <td>{{ $bd->deadline }}</td>
                <td>
                    @if($bd->status == 1)
                      <span class="chip green lighten-5">
                        <span class="green-text">Active</span>
                      </span>
                    @elseif($bd->status == 2)
                      <span class="chip red lighten-5">
                        <span class="red-text">In active</span>
                      </span>
                    @endif
                </td>
                <td>
                  <a href="{{asset('page-jobs-edit')}}/{{Crypt::encrypt($bd->id)}}"><i class="material-icons">edit</i></a>
                  <a href="{{asset('page-jobs-show')}}/{{Crypt::encrypt($bd->id)}}"><i class="material-icons">remove_red_eye</i></a>
                  <a href="{{asset('page-jobs-delete')}}/{{Crypt::encrypt($bd->id)}}"><i class="material-icons">delete</i></a>
                </td>
              </tr>
            @endforeach
            </tbody>
          </table>
        </div>
        <!-- datatable ends -->
      </div>
    </div>
  </div>
</section>
<!-- users list ends -->
@endsection

{{-- vendor scripts --}}
@section('vendor-script')
<script src="{{asset('vendors/data-tables/js/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('vendors/data-tables/extensions/responsive/js/dataTables.responsive.min.js')}}"></script>
@endsection

{{-- page script --}}
@section('page-script')
<script src="{{asset('js/scripts/page-users.js')}}"></script>
<script src="{{asset('js/scripts/ui-alerts.js')}}"></script>
@endsection