{{-- layout --}}
@extends('layouts.contentLayoutMaster')

{{-- page title --}}
@section('title','Users edit')

{{-- vendor styles --}}
@section('vendor-style')
<link rel="stylesheet" type="text/css" href="{{asset('vendors/select2/select2.min.css')}}">
<link rel="stylesheet" type="text/css" href="{{asset('vendors/select2/select2-materialize.css')}}">
<link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-fileinput/4.4.7/css/fileinput.css" media="all" rel="stylesheet" type="text/css"/>
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css" media="all" rel="stylesheet" type="text/css"/>
<style type="text/css">
    .main-section{
        margin:0 auto;
        padding: 20px;
        margin-top: 100px;
        background-color: #fff;
        box-shadow: 0px 0px 20px #c1c1c1;
    }
    .fileinput-remove,
    .fileinput-upload{
        display: none;
    }

    tr{
        border-bottom: none !important;
    }
</style>
@endsection

{{-- page style --}}
@section('page-style')
<link rel="stylesheet" type="text/css" href="{{asset('css/pages/page-users.css')}}">
@endsection

{{-- page content --}}
@section('content')
<!-- users edit start -->
<div class="section users-edit">
  <div class="card">
    <div class="card-content custom-card">
      <div class="row">
        <div class="col s6">
          <h5 class="page-topic">Edit Job </h5>
          <p class="custom-breadcrumbs">
            <a href="{{asset('filtered-dashboard')}}">Home</a> > <a href="{{asset('page-jobs-list')}}">Jobs </a> > <a> Edit Job </a></p>
        </div>
      </div>
    </div>
  </div>

  <div class="card">
    <div class="row">

      <div class="col s12 m12 l12">
        <div id="Form-advance" class="scrollspy">
          <div class="card-content">
            <form action="{{asset('page-jobs-update')}}/{{Crypt::encrypt($jobs->id)}}" enctype="multipart/form-data" method="POST" id="jobs-edit">
              {{ csrf_field() }}
              <div class="row">
                <div class="input-field col m6 s12">
                    <p for="job_no"><b>Job Number *</b></p>
                  <input class="validate" required id="job_no" name="job_no" type="text" value="{{$jobs->job_no}}" readonly>
                </div>

                  <div class="input-field col m6 s12">
                      <p for="deadline"><b>Deadline *</b></p>
                      <input type="text" class="datepicker" id="deadline" name="deadline" value="{{ $jobs->deadline }}" required>
                  </div>
              </div>

              <div class="row">
                <div class="input-field col s12">
                    <p for="product"><b>Product Name *</b></p>
                  <input class="validate" required id="product" name="product" type="text" value="{{$jobs->product}}" >
                </div>
              </div>

              <div class="row">
                <div class="input-field col s12">
                  <p for="description"><b>Description</b></p>
                  <textarea id="description" class="materialize-textarea" name="description" id="description">{{ $jobs->description }}</textarea>
                </div>
              </div>

              <div class="row">
                  <p class="text-center text-danger">&nbsp;&nbsp;&nbsp;<b>Upload Files</b></p><br>
                <div class="input-field col s12">
                    @foreach($job_uploads as $ja)
                    <?php
                                $finfo = finfo_open(FILEINFO_MIME_TYPE);
                                $type = finfo_file($finfo, "upload/$ja->attached");
                                
                                if (isset($type) && in_array($type, array("image/png", "image/jpeg", "image/gif"))) {
                                    $image = 1;
                                } else {
                                     $image = 0;
                                }
    
                            ?>
                            @if($image == 1)
                                <img src="{{asset('upload')}}/{{$ja->attached}}" style="max-width: 200px; max-height:250px;">
                                <a href="{{asset('job-attached-delete')}}/{{Crypt::encrypt($ja->job_id)}}/{{$ja->id}}" class="delete-attached"><i class="material-icons">delete</i> </a>&nbsp;                            @else
                                <iframe src="{{asset('upload')}}/doc_image.png" height="150" width="150"></iframe>
                                 <a href="{{asset('job-attached-delete')}}/{{Crypt::encrypt($ja->job_id)}}/{{$ja->id}}" class="delete-attached"><i class="material-icons">delete</i> </a>&nbsp;

                            @endif
                   
                    @endforeach
                  <br>
                  <div class="file-loading">
                    <input id="file" type="file" name="file[]" multiple class="file" data-overwrite-initial="false">
                  </div>
                </div>
              </div>

                <br>
<!--
                @if((Auth::user()->role == 1 || Auth::user()->role == 2))
                <div class="row">
                    <p class="text-center text-danger">&nbsp;&nbsp;&nbsp;<b>Show to client only</b></p><br>
                    <div class="input-field col s12">
                        @foreach($job_uploads as $ja)
                            <img src="{{asset('/upload')}}/{{$ja->attached_client}}" style="max-width: 200px; max-height:250px;"><a href="{{asset('job-attached-delete')}}/{{Crypt::encrypt($ja->job_id)}}/{{$ja->id}}" class="delete-attached"><i class="material-icons">delete</i> </a>&nbsp;
                        @endforeach
                        <br>
                        <div class="file-loading">
                            <input id="file-client" type="file" name="file-client[]" multiple class="file" data-overwrite-initial="false">
                        </div>
                    </div>
                </div>
                @endif-->

                <br>

              <div class="row">
                  <div class="input-field col m6 s12">
                      <p for="brand"><b>Brands *</b></p>
                      <select class="select2 browser-default"  id="brand" name="brand">
                        @foreach($brands as $bd)
                          <option value="{{ $bd->id }}" @if($jobs->brand == $bd->id) selected @else @endif >{{ $bd->name }}</option>
                        @endforeach
                      </select>
                  </div>
                  <div class="input-field col m6 s12">
                      <p for="managers"><b>Related Managers</b></p>
                      <select class="select2 browser-default" multiple="multiple" id="manager" name="manager">
                          @foreach($managers as $mn)
                              <option value="{{ $mn->id }}" @if($mn->id == $jobs->related_manager) selected @else  @endif>{{ $mn->name }}</option>
                          @endforeach
                      </select>
                  </div>
              </div>

              <br>

              <div class="row">
                <p for="assigned" style="padding-left: 15px;"><b>Assigned to</b></p>
                <div class="input-field col s3">
                  <p for="strategy">Strategy </p>

                  <select class="select2 browser-default"  id="strategy" name="strategy">
                    @foreach($strategy as $us)
                      @if($jobs->stratgy == NULL)
                        <option value="" selected> Select </option>
                        <option value="{{ $us->id }}">{{ $us->name }}</option>
                      @else
                        <option value="{{ $us->id }}" @if($jobs->stratgy == $us->id) selected @else @endif >{{ $us->name }}</option>
                      @endif
                    @endforeach
                        <option value="" > Select </option>
                  </select>
                </div>
                <div class="input-field col s3">
                  <p for="cw">Copy Writer</p>

                  <select class="select2 browser-default"  id="copy" name="copy">
                    @foreach($copy_writers as $us)
                      @if($jobs->copy == NULL)
                        <option value="" selected> Select </option>
                        <option value="{{ $us->id }}">{{ $us->name }}</option>
                      @else
                        <option value="{{ $us->id }}" @if($jobs->copy == $us->id) selected @else @endif >{{ $us->name }}</option>
                      @endif
                    @endforeach
                        <option value="" > Select </option>
                  </select>
                </div>

                <div class="input-field col s3">
                  <p for="des">Designer </p>
                  <select class="select2 browser-default"  id="designer" name="designer">
                    @foreach($designers as $us)
                      @if($jobs->designer == NULL)
                        <option value="" selected> Select </option>
                        <option value="{{ $us->id }}">{{ $us->name }}</option>
                      @else
                        <option value="{{ $us->id }}" @if($jobs->designer == $us->id) selected @else @endif >{{ $us->name }}</option>
                      @endif
                    @endforeach
                        <option value="" > Select </option>
                  </select>
                </div>

                <div class="input-field col s3">
                  <p for="art">Head of Creative </p>
                  <select class="select2 browser-default"  id="art" name="art">
                    @foreach($art as $us)
                      @if($jobs->art == NULL)
                        <option value="" selected> Select </option>
                        <option value="{{ $us->id }}">{{ $us->name }}</option>
                      @else
                        <option value="{{ $us->id }}" @if($jobs->art == $us->id) selected @else @endif >{{ $us->name }}</option>
                      @endif
                    @endforeach
                        <option value="" > Select </option>
                  </select>
                </div>

              </div>

              <div class="row">
                <div class="input-field col s3">
                  <p for="assigned">Media Manager</p>
                  <select class="select2 browser-default"  id="media" name="media">
                    @foreach($medias as $us)
                      @if($jobs->media == NULL)
                        <option value="" selected> Select </option>
                        <option value="{{ $us->id }}">{{ $us->name }}</option>
                      @else
                        <option value="{{ $us->id }}" @if($jobs->media == $us->id) selected @else @endif >{{ $us->name }}</option>
                      @endif
                    @endforeach
                        <option value=""> Select </option>
                  </select>
                </div>
                <div class="input-field col s3">
                  <p for="assigned">Client </p>

                  <select class="select2 browser-default"  id="client" name="client">
                    @foreach($clients as $us)
                      @if($jobs->client == NULL)
                        <option value="" selected> Select </option>
                        <option value="{{ $us->id }}">{{ $us->name }}</option>
                      @else
                        <option value="{{ $us->id }}" @if($jobs->client == $us->id) selected @else @endif >{{ $us->name }}</option>
                      @endif
                    @endforeach
                        <option value=""> Select </option>
                  </select>
                </div>
              </div>
<br>
                <div class="row">
                    <div class="input-field col s12">
                        <p for="status"><b>Number of sub tasks completed</b></p>
                        <br>
                        <table>
                            <thead>
                                <tr>
                                    <th>Strategy</th>
                                    <th>Copy Writer</th>
                                    <th>Designer</th>
                                    <th>Head of Creative</th>
                                    <th>Media Manager</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td><input type="number" name="str" value="{{$jobs->str}}" style="width: 60%;"></td>
                                    <td><input type="number" name="cw" value="{{$jobs->cw}}" style="width: 60%;"></td>
                                    <td><input type="number" name="des" value="{{$jobs->des}}" style="width: 60%;"></td>
                                    <td><input type="number" name="hoc" value="{{$jobs->hoc}}" style="width: 60%;"></td>
                                    <td><input type="number" name="mm" value="{{$jobs->mm}}" style="width: 60%;"></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

              <div class="row">
                <div class="input-field col m6 s12">
                  <p for="status"><b>Job Status</b> </p>
                  <select class="select2 browser-default" id="status" name="status">
                      <option value="1" @if($jobs->status == 1) selected @endif>Approval Pending</option>
                      <option value="2" @if($jobs->status == 2) selected @endif>Job Created - Account Mangement </option>
                      <option value="3" @if($jobs->status == 3) selected @endif>Strategy In Progress</option>
                      <option value="4" @if($jobs->status == 4) selected @endif>Strategy Job Completed</option>
                      <option value="5" @if($jobs->status == 5) selected @endif>Copy Writer In Progress</option>
                      <option value="6" @if($jobs->status == 6) selected @endif>Copy Writer Job Completed</option>
                      <option value="7" @if($jobs->status == 7) selected @endif>Art Director In Progress</option>
                      <option value="8" @if($jobs->status == 8) selected @endif>Art Director Job Completed</option>
                      <option value="9" @if($jobs->status == 9) selected @endif>Sent to Client</option>
                      <option value="10" @if($jobs->status == 10) selected @endif>TVC Production</option>
                      <option value="11" @if($jobs->status == 11) selected @endif>Media</option>
                      <option value="12" @if($jobs->status == 12) selected @endif>Delivered</option>
                  </select>
                </div>

              </div>

              <div class="row">
                <div class="input-field col s12">
                  <button class="btn cyan waves-effect waves-light right" type="submit" name="action">Submit</button>
                </div>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
@endsection

{{-- vendor scripts --}}
@section('vendor-script')
<script src="{{asset('vendors/select2/select2.full.min.js')}}"></script>
<script src="{{asset('vendors/jquery-validation/jquery.validate.min.js')}}"></script>
<script src="{{asset('vendors/select2/select2.full.min.js')}}"></script>
@endsection

{{-- page scripts --}}
@section('page-script')
<script src="{{asset('js/scripts/page-users.js')}}"></script>
<script src="{{asset('js/scripts/form-select2.js')}}"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-fileinput/4.4.7/js/fileinput.js" type="text/javascript"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-fileinput/4.4.7/themes/fa/theme.js" type="text/javascript"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.11.0/umd/popper.min.js" type="text/javascript"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0-beta/js/bootstrap.min.js" type="text/javascript"></script>


{{--<script type="text/javascript">
    $("#file-1").fileinput({
        theme: 'fa',
        uploadUrl: "{{asset('page-jobs-update')}}/{{$jobs->id}}",
        uploadExtraData: function() {
            return {
                _token: $("input[name='_token']").val(),
            };
        },
        allowedFileExtensions: ['jpg', 'png', 'gif', 'pdf'],
        overwriteInitial: false,
        maxFileSize:8000,
        maxFilesNum: 10,
        slugCallback: function (filename) {
            return filename.replace('(', '_').replace(']', '_');
        }

    });
</script>--}}

<script>
    $(document).ready(function(){
        $('.datepicker').datepicker();
    });

    $('#description').val();
    M.textareaAutoResize($('#descrption'));
</script>
@endsection