{{-- layout --}}
@extends('layouts.contentLayoutMaster')

{{-- page title --}}
@section('title','Job Add')

{{-- vendor styles --}}
@section('vendor-style')
<link rel="stylesheet" type="text/css" href="{{asset('vendors/select2/select2.min.css')}}">
<link rel="stylesheet" type="text/css" href="{{asset('vendors/select2/select2-materialize.css')}}">
<link rel="stylesheet" type="text/css" href="{{asset('vendors/flag-icon/css/flag-icon.min.css')}}">
@endsection

{{-- page style --}}
@section('page-style')
<link rel="stylesheet" type="text/css" href="{{asset('css/pages/page-users.css')}}">
<link rel="stylesheet" type="text/css" href="{{asset('css/pages/form-select2.css')}}">
<link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-fileinput/4.4.7/css/fileinput.css" media="all" rel="stylesheet" type="text/css"/>
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css" media="all" rel="stylesheet" type="text/css"/>
<style type="text/css">
  .main-section{
    margin:0 auto;
    padding: 20px;
    margin-top: 100px;
    background-color: #fff;
    box-shadow: 0px 0px 20px #c1c1c1;
  }
  .fileinput-remove,
  .fileinput-upload{
    display: none;
  }
</style>
@endsection

{{-- page content --}}
@section('content')
<!-- users edit start -->
<div class="section users-edit">
  <div class="card">
    <div class="card-content custom-card">
      <div class="row">
        <div class="col s6">
          <h5 class="page-topic">Add Jobs </h5>
          <p class="custom-breadcrumbs">
            <a href="{{asset('filtered-dashboard')}}">Home</a> > <a href="{{asset('page-jobs-list')}}">Jobs </a> > <a href=""> Add Job </a></p>
        </div>
      </div>
    </div>
  </div>

  <div class="card">
    <div class="row">
        <div class="col s12 m12 l12">
          <div id="Form-advance" class="scrollspy">
            <div class="card-content">
              <form action="{{asset('page-jobs-store')}}" enctype="multipart/form-data"  method="POST" id="job-add">
                {{ csrf_field() }}
                <div class="row">
                    <div class="input-field col m6 s12">
                        <p for="job_no"><b>Job Number *</b></p>
                        <input class="validate" required id="job_no" name="job_no" type="text" value="{{$job_no}}" readonly>
                    </div>

                    <div class="input-field col m6 s12">
                        <p for="deadline"><b>Deadline *</b> </p>
                        <input type="text" id="deadline" name="deadline" class="datepicker" required>
                    </div>
                </div>

                <div class="row">
                  <div class="input-field col s12">
                      <p for="product"><b>Product Name *</b></p>
                    <input class="validate" required id="product" name="product" type="text" value="" >
                  </div>
                </div>

                <div class="row">
                  <div class="input-field col s12">
                    <p for="description"><b>Description</b></p>
                    <textarea id="description" class="materialize-textarea" name="description" id="description"></textarea>
                  </div>
                </div>

                <div class="row">
                    <p class="text-center text-danger">&nbsp;&nbsp;&nbsp;<b>Upload Files</b></p><br>
                  <div class="input-field col s12">
                    <div class="file-loading">
                      <input id="file" type="file" name="file[]" multiple class="file" data-overwrite-initial="false">
                    </div>
                  </div>
                </div>

                  <br>
                <div class="row">
                  <div class="input-field col m6 s12">
                    <p for="brand"><b>Brand *</b></p>
                    <select class="select2 browser-default" id="brand" name="brand">
                      @foreach($brands as $bd)
                        <option value="{{ $bd->id }}">{{ $bd->name }}</option>
                      @endforeach
                    </select>
                  </div>
                    <div class="input-field col m6 s12">
                        <p for="brand"><b>Related Managers</b></p>
                        <select class="select2 browser-default"  id="manager" name="manager">
                            @foreach($managers as $mn)
                                <option value="{{ $mn->id }}">{{ $mn->name }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>


                <br>

                <div class="row">
                    <p for="assigned" style="padding-left: 15px;"><b>Assigned to</b></p>
                      <div class="input-field col s3">
                        <p for="assigned">Strategy </p>

                        <select class="select2 browser-default"  id="strategy" name="strategy">
                          @foreach($strategy as $us)
                            <option value=""> Select </option>
                            <option value="{{ $us->id }}">{{ $us->name }}</option>
                          @endforeach
                        </select>
                      </div>
                      <div class="input-field col s3">
                          <p for="assigned">Copy Writer </p>

                          <select class="select2 browser-default"  id="copy" name="copy">
                              @foreach($copy_writers as $us)
                                  <option value=""> Select </option>
                                  <option value="{{ $us->id }}">{{ $us->name }}</option>
                              @endforeach
                          </select>
                      </div>
                        <div class="input-field col s3">
                            <p for="assigned">Designer </p>
                            <select class="select2 browser-default"  id="designer" name="designer">
                                @foreach($designers as $us)
                                    <option value=""> Select </option>
                                    <option value="{{ $us->id }}">{{ $us->name }}</option>
                                @endforeach
                            </select>
                        </div>
                      <div class="input-field col s3">
                          <p for="assigned">Head of Creative </p>
                          <select class="select2 browser-default"  id="art" name="art">
                              @foreach($art as $us)
                                  <option value=""> Select </option>
                                  <option value="{{ $us->id }}">{{ $us->name }}</option>
                              @endforeach
                          </select>
                      </div>

                </div>

                <div class="row">
                    <div class="input-field col s3">
                        <p for="assigned">Media Manager </p>
                        <select class="select2 browser-default"  id="media" name="media">
                            @foreach($medias as $us)
                                <option value=""> Select </option>
                                <option value="{{ $us->id }}">{{ $us->name }}</option>
                            @endforeach
                        </select>
                    </div>
                  <div class="input-field col s3">
                      <p for="assigned">Client </p>

                      <select class="select2 browser-default"  id="client" name="client">
                          @foreach($clients as $us)
                              <option value=""> Select </option>
                              <option value="{{ $us->id }}">{{ $us->name }}</option>
                          @endforeach
                      </select>
                  </div>
                </div>

                <div class="row">
                  <div class="input-field col m6 s12">
                    <p for="status"><b>Job Status</b></p>
                    <select class="select2 browser-default" id="status" name="status">
                        <option value="1">Approval Pending</option>
                        <option value="2">Job Created - Account Management</option>
                        <option value="3">Strategy In Progress</option>
                        <option value="4">Strategy Job Completed</option>
                        <option value="5">Copy Writer In Progress</option>
                        <option value="6">Copy Writer Job Completed</option>
                        <option value="7">Art Director In Progress</option>
                        <option value="8">Art Director Job Completed</option>
                        <option value="9">TVC Production</option>
                        <option value="10">Media</option>
                        <option value="11">Delivered</option>
                    </select>
                  </div>

                </div>

                <div class="row">
                  <div class="input-field col s12">
                    <button class="btn cyan waves-effect waves-light right" type="submit" name="action">Submit</button>
                  </div>
                </div>
              </form>
            </div>
          </div>
        </div>
      </div>
    </div>
</div>
<!-- users edit ends -->
@endsection

{{-- vendor scripts --}}
@section('vendor-script')
<script src="{{asset('vendors/select2/select2.full.min.js')}}"></script>
<script src="{{asset('vendors/jquery-validation/jquery.validate.min.js')}}"></script>
<script src="{{asset('vendors/select2/select2.full.min.js')}}"></script>
@endsection

{{-- page scripts --}}
@section('page-script')
<script src="{{asset('js/scripts/page-users.js')}}"></script>
<script src="{{asset('js/scripts/form-select2.js')}}"></script>
{{--
<script src="https://code.jquery.com/jquery-3.2.1.min.js"></script>
--}}
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-fileinput/4.4.7/js/fileinput.js" type="text/javascript"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-fileinput/4.4.7/themes/fa/theme.js" type="text/javascript"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.11.0/umd/popper.min.js" type="text/javascript"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0-beta/js/bootstrap.min.js" type="text/javascript"></script>


{{--<script type="text/javascript">
  $("#file-1").fileinput({
    theme: 'fa',
    uploadUrl: "{{asset('image-store')}}",
    uploadExtraData: function() {
      return {
        _token: $("input[name='_token']").val(),
      };
    },
    allowedFileExtensions: ['jpg', 'png', 'gif', 'pdf'],
    overwriteInitial: false,
    maxFileSize:8000,
    maxFilesNum: 10,
    slugCallback: function (filename) {
      return filename.replace('(', '_').replace(']', '_');
    }

  });
</script>--}}

<script>
  $(document).ready(function(){
    $('.datepicker').datepicker();
  });

  $('#description').val();
  M.textareaAutoResize($('#descrption'));
</script>
@endsection
