{{-- layout --}}
@extends('layouts.contentLayoutMaster')

{{-- page title --}}
@section('title','Users edit')

{{-- vendor styles --}}
@section('vendor-style')
<link rel="stylesheet" type="text/css" href="{{asset('vendors/select2/select2.min.css')}}">
<link rel="stylesheet" type="text/css" href="{{asset('vendors/select2/select2-materialize.css')}}">
@endsection

{{-- page style --}}
@section('page-style')
<link rel="stylesheet" type="text/css" href="{{asset('css/pages/page-users.css')}}">
<link rel="stylesheet" type="text/css" href="{{asset('css/pages/form-select2.css')}}">
@endsection

{{-- page content --}}
@section('content')
<!-- users edit start -->
<div class="section users-edit">
  <div class="card">
    <div class="card-content custom-card">
      <div class="row">
        <div class="col s6">
          <h5 class="page-topic">Add Brands </h5>
          <p class="custom-breadcrumbs">
            <a href="">Home</a> > <a href="">Brands </a> > <a href=""> Add Brands </a></p>
        </div>
      </div>
    </div>
  </div>

  <div class="card">
    <div class="row">
        <div class="col s12 m12 l12">
          <div id="Form-advance" class="scrollspy">
            <div class="card-content">
              <form action="{{asset('page-brands-store')}}" method="POST" id="brand-add">
                {{ csrf_field() }}
                <div class="row">
                  <div class="input-field col m6 s12">
                    <label for="code">Brand Code *</label>
                    <input class="validate" required id="code" name="code" type="text">
                  </div>
                  <div class="input-field col m6 s12">
                    <label for="name">Brand name *</label>
                    <input class="validate" required id="name" name="name" type="text">
                  </div>
                </div>
                <div class="row">
                  <div class="input-field col s12">
                    <button class="btn cyan waves-effect waves-light right" type="submit" name="action">Submit
                    </button>
                  </div>
                </div>
              </form>
            </div>
          </div>
        </div>
      </div>
    </div>
</div>
<!-- users edit ends -->
@endsection

{{-- vendor scripts --}}
@section('vendor-script')
<script src="{{asset('vendors/select2/select2.full.min.js')}}"></script>
<script src="{{asset('vendors/jquery-validation/jquery.validate.min.js')}}"></script>
<script src="{{asset('vendors/select2/select2.full.min.js')}}"></script>
@endsection

{{-- page scripts --}}
@section('page-script')
<script src="{{asset('js/scripts/page-users.js')}}"></script>
<script src="{{asset('js/scripts/form-select2.js')}}"></script>
@endsection
