{{-- layout --}}
@extends('layouts.fullLayoutMaster')

{{-- page title --}}
@section('title','User Register')

{{-- page style --}}
@section('page-style')
<link rel="stylesheet" type="text/css" href="{{asset('css/pages/register.css')}}">
@endsection

{{-- page content --}}
@section('content')
<div id="register-page" class="row">
  <div class="col s12 m6 l4 z-depth-4 card-panel border-radius-6 register-card bg-opacity-8">
    <form action="{{url('post-register')}}" method="POST" id="regForm" class="login-form">
      {{ csrf_field() }}
      <div class="row">
        <div class="input-field col s12">
          <h5 class="ml-4">Register</h5>
          <p class="ml-4">Join to our community now !</p>
        </div>
      </div>
      <div class="row margin">
        <div class="input-field col s12">
          <i class="material-icons prefix pt-2">person_outline</i>
          <input id="name" name="name" type="text" value="">
          <label for="name" class="center-align">Username</label>
          @if ($errors->has('name'))
            <div class="alert alert-danger" style="color: red;">{{ $errors->first('name') }}</div>
          @endif
        </div>
      </div>
      <div class="row margin">
        <div class="input-field col s12">
          <i class="material-icons prefix pt-2">mail_outline</i>
          <input id="email" name="email" type="email" value="">
          <label for="email">Email</label>
          @if ($errors->has('email'))
            <div class="alert alert-danger" style="color: red;">{{ $errors->first('email') }}</div>
          @endif
        </div>
      </div>
      <div class="row margin">
        <div class="input-field col s12">
          <i class="material-icons prefix pt-2">lock_outline</i>
          <input id="password" name="password" type="password" value="">
          <label for="password">Password</label>
          @if ($errors->has('password'))
            <div class="alert alert-danger" style="color: red;">{{ $errors->first('password') }}</div>
          @endif
        </div>
      </div>
      <div class="row margin">
        <div class="input-field col s12">
          <i class="material-icons prefix pt-2">lock_outline</i>
          <input id="password-again" name="password-again"  type="password" value="">
          <label for="password-again">Password again</label>
          @if ($errors->has('password-again'))
            <div class="alert alert-danger" style="color: red;">{{ $errors->first('password-again') }}</div>
          @endif
        </div>
      </div>
      <div class="row">
        <div class="input-field col s12">
          <button class="btn waves-effect waves-light border-round gradient-45deg-purple-deep-orange col s12" type="submit">Register</button>
        </div>
      </div>
      <div class="row">
        <div class="input-field col s12">
          <p class="margin medium-small"><a href="{{asset('user-login')}}">Already have an account? Login</a></p>
        </div>
      </div>
    </form>
  </div>
</div>
@endsection