<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;

class MenuServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        // get all data from menu.json file
        $verticalMenuJson = file_get_contents(base_path('resources/json/verticalMenu.json'));
        $verticalMenuData= json_decode($verticalMenuJson);

        $verticalMenuJsonClient = file_get_contents(base_path('resources/json/verticalMenuClient.json'));
        $verticalMenuDataClient = json_decode($verticalMenuJsonClient);

        $verticalMenuJsonOther = file_get_contents(base_path('resources/json/verticalMenuOther.json'));
        $verticalMenuDataOther = json_decode($verticalMenuJsonOther);

        $horizontalMenuJson=file_get_contents(base_path('resources/json/horizontalMenu.json'));
        $horizontalMenuData= json_decode($horizontalMenuJson);

        // share all menuData to all the views
        \View::share('menuData',[$verticalMenuData, $horizontalMenuData, $verticalMenuDataClient, $verticalMenuDataOther]);
    }
}
