<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Job extends Model
{
    protected $table = 'jobs';
    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = ['job_no', 'name'];

    public function users()
    {
        return $this->hasMany('App\User', 'id');
    }



    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function comments()
    {
        return $this->morphMany(Comment::class, 'commentable')->whereNull('parent_id');
    }
}
