<?php

namespace App\Http\Controllers;

use App\Brand;
use App\User;
use App\Role;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;
use phpseclib\Crypt\Hash;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;

class UserController extends Controller
{
    public function usersList()
    {

        $breadcrumbs = [
            ['link' => "modern", 'name' => "Home"], ['link' => "javascript:void(0)", 'name' => "User"], ['name' => "Users List"]];
        //Pageheader set true for breadcrumbs
        $pageConfigs = ['pageHeader' => false, 'isFabButton' => true];
        $users = User::where('status',1)->get();
        return view('users.page-users-list', ['users'=>$users, 'pageConfigs' => $pageConfigs], ['breadcrumbs' => $breadcrumbs]);
    }

    public function create()
    {
        $breadcrumbs = [
            ['link' => "modern", 'name' => "Home"], ['link' => "javascript:void(0)", 'name' => "User"], ['name' => "Users List"]];
        //Pageheader set true for breadcrumbs
        $pageConfigs = ['pageHeader' => false, 'isFabButton' => true];

        $roles = Role::where('status',1)->get();
        $brands = Brand::where('status',1)->get();

        return view('users.page-users-add', ['roles'=>$roles], ['brands'=>$brands], ['pageConfigs' => $pageConfigs], ['breadcrumbs' => $breadcrumbs]);
    }

    public function store(Request $request){

        request()->validate([
            'uname0' => 'required',
            'password0'=>'required|min:6',
            /*   'email' => 'required|email|unique:users'*/
            /*'good_name'=>'required',
            'role'=>'required',
            'brands'=>'required',
            'pic' => 'mimes:jpg,png|max:12000'*/
        ]);

        if($request->file) {
            $fileName = time() . '.' . $request->file->extension();
            $request->file->move(public_path('upload/users/'), $fileName);
        }


        $user  = new User();
        $user->name = $request->get('uname0');
        $user->email = $request->get('email');
        $user->password = $request->get('password0');
        $user->good_name = $request->get('name0');

        if($request->get('dob')) {
            $date1 = strtr($request->get('dob'), '/', '-');
            $user->dob = date('Y-m-d', strtotime($date1));
        }

        $user->role = $request->get('role');
        $user->status = $request->get('status');
        $user->brands = implode(',' ,$request->get('brands'));

        if($request->file) {
            $user->pic = 'upload/users/' . $fileName;
        }
        $user->save();

        return Redirect::to("page-users-list")->with('success','User saved successfully');

    }

    public function edit($id)
    {
        $breadcrumbs = [
            ['link' => "modern", 'name' => "Home"], ['link' => "javascript:void(0)", 'name' => "User"], ['name' => "Users Edit"]];
        //Pageheader set true for breadcrumbs
        $pageConfigs = ['pageHeader' => false, 'isFabButton' => true];

        $users = User::where('id',Crypt::decrypt($id))->first();
        $roles = Role::where('status',1)->get();
        $brands = Brand::where('status',1)->get();

        return view('users.page-users-edit', ['roles'=>$roles, 'brands'=>$brands, 'users'=>$users , 'pageConfigs' => $pageConfigs , 'breadcrumbs' => $breadcrumbs]);
    }

    public function update(Request $request, $id)
    {
        $selected_brands = implode(',' ,$request->get('brands'));

        if($request->file) {
            $fileName = time() . '.' . $request->file->extension();
            $request->file->move(public_path('upload/users/'), $fileName);
            $pic = 'upload/users/' . $fileName;

            $users = DB::table('users')
                ->where('id', Crypt::decrypt($id))
                ->update(['pic'=>$pic,]);
        }

        $users = DB::table('users')
            ->where('id', Crypt::decrypt($id))
            ->update(['brands'=>$selected_brands,'dob'=>$request->get('dob'),'good_name'=>$request->get('name0'),'name' => $request->get('uname0'), 'role' =>$request->get('role'), 'status' =>$request->get('status')]);

        return Redirect::to("page-users-list")->with('success','User updated successfully');

    }

    public function show($id)
    {
        $breadcrumbs = [
            ['link' => "modern", 'name' => "Home"], ['link' => "javascript:void(0)", 'name' => "User"], ['name' => "Users View"]];
        //Pageheader set true for breadcrumbs
        $pageConfigs = ['pageHeader' => false, 'isFabButton' => true];

        $users = User::where('id',Crypt::decrypt($id))->first();
        $roles = Role::where('status',1)->get();
        $brands = Brand::where('status',1)->get();

        return view('users.page-users-view', ['users'=>$users, 'roles'=>$roles, 'brands'=>$brands, 'pageConfigs' => $pageConfigs], ['breadcrumbs' => $breadcrumbs]);
    }



}
