<?php

namespace App\Http\Controllers;

use App\Role;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;
use Illuminate\Http\RedirectResponse;
use Laracasts\Flash\Flash;
use Illuminate\Support\Facades\Crypt;

class RoleController extends Controller
{

    public function index()
    {
        $breadcrumbs = [
            ['link' => "modern", 'name' => "Home"], ['link' => "javascript:void(0)", 'name' => "Brand"], ['name' => "Brands"]];
        //Pageheader set true for breadcrumbs
        $pageConfigs = ['pageHeader' => false, 'isFabButton' => true];
        $roles = Role::all();

        return view('roles.page-roles-list', ['roles'=>$roles, 'pageConfigs' => $pageConfigs], ['breadcrumbs' => $breadcrumbs]);
    }

    public function create()
    {
        $breadcrumbs = [
            ['link' => "modern", 'name' => "Home"], ['link' => "javascript:void(0)", 'name' => "User"], ['name' => "Users List"]];
        //Pageheader set true for breadcrumbs
        $pageConfigs = ['pageHeader' => false, 'isFabButton' => true];

        return view('roles.page-roles-add', ['pageConfigs' => $pageConfigs], ['breadcrumbs' => $breadcrumbs]);
    }

    public function store(Request $request)
    {
        request()->validate([
            'name' => 'required',
            'code' => 'required',
        ]);

        $brand  = new Role();
        $brand->name = $request->get('name');
        $brand->code = $request->get('code');
        $brand->status = 1;
        $brand->save();

        return Redirect::to("page-roles-list")->with('success','Role saved successfully');
    }

    public function edit($id)
    {
        $breadcrumbs = [
            ['link' => "modern", 'name' => "Home"], ['link' => "javascript:void(0)", 'name' => "User"], ['name' => "Users Edit"]];
        //Pageheader set true for breadcrumbs
        $pageConfigs = ['pageHeader' => false, 'isFabButton' => true];
        $roles = Role::where('id', Crypt::decrypt($id))->first();

        return view('roles.page-roles-edit', ['roles'=>$roles, 'pageConfigs' => $pageConfigs], ['breadcrumbs' => $breadcrumbs]);
    }

    public function update(Request $request, $id)
    {
        $brands = DB::table('roles')
            ->where('id', Crypt::decrypt($id))
            ->update(['name' => $request->get('name'), 'code' =>$request->get('code')]);

        return Redirect::to("page-roles-list")->with('success','Role updated successfully');

    }

    public function show($id)
    {
        //
    }

    public function destroy($id)
    {
        $roles =  Role::where('id',Crypt::decrypt($id))->delete();
        return Redirect::to("page-roles-list")->with('success','Role deleted successfully');
    }
}
