<?php

namespace App\Http\Controllers;

use App\JobComment;
use App\JobUpload;
use Illuminate\Support\Facades\Auth;
use App\Brand;
use App\Job;
use App\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Str;
use Illuminate\Database\Query\Builder;
use Illuminate\Support\Facades\Storage;

class JobController extends Controller
{
    public function index()
    {
        $breadcrumbs = [
            ['link' => "modern", 'name' => "Home"], ['link' => "javascript:void(0)", 'name' => "Brand"], ['name' => "jobs"]];
        //Pageheader set true for breadcrumbs
        $pageConfigs = ['pageHeader' => false, 'isFabButton' => true];
        $jobs = Job::orderBy('created_at','DESC')->get();

        return view('jobs.page-jobs-list', ['jobs'=>$jobs, 'pageConfigs' => $pageConfigs], ['breadcrumbs' => $breadcrumbs]);
    }

    public function create()
    {
        $breadcrumbs = [
            ['link' => "modern", 'name' => "Home"], ['link' => "javascript:void(0)", 'name' => "User"], ['name' => "Users List"]];
        //Pageheader set true for breadcrumbs
        $pageConfigs = ['pageHeader' => false, 'isFabButton' => true];

        $job = Job::withTrashed()->latest()->first();
        if(!empty($job) > 0) {
            $job_id = $job->id + 1;
        }else{
            $job_id = 1;
        }
        $job_no = 'JOB'.str_pad($job_id,5,'0',STR_PAD_LEFT);
        $auth_user = Auth::user()->id;

        $brands_related_to_user = User::where('id',$auth_user)->first();
        $arr = explode(',',$brands_related_to_user->brands);
        $brands = Brand::whereIn('id',$arr)->get();
        $users = User::where('status',1)->get();


        $managers = User::where('status',1)->where('role',2)->get();
        $clients = User::where('status',1)->where('role',9)->get();
        $medias = User::where('status',1)->where('role',4)->get();
        $copy_writers = User::where('status',1)->where('role',3)->get();
        $designers = User::where('status',1)->where('role',7)->get();
        $strategy = User::where('status',1)->where('role',8)->get();
        $art = User::where('status',1)->where('role',5)->get();

        return view('jobs.page-jobs-add', ['art'=>$art,'strategy'=>$strategy,'designers'=>$designers,'copy_writers'=>$copy_writers,'medias'=>$medias,'clients'=>$clients,'users'=>$users, 'managers'=>$managers, 'brands'=>$brands,'job_no'=>$job_no, 'pageConfigs' => $pageConfigs], ['breadcrumbs' => $breadcrumbs]);
    }



    public function store(Request $request)
    {
        request()->validate([
            'product' => 'required',
            'brand' => 'required',
            'job_no'=>'required',
        ]);

        $job  = new Job();
        $job->job_no = $request->get('job_no');
        $job->deadline = $request->get('deadline');
        $job->product = $request->get('product');
        $job->description = $request->get('description');
        $job->brand = $request->get('brand');
        $job->stratgy = $request->get('strategy');
        $job->copy = $request->get('copy');
        $job->art = $request->get('art');
        $job->designer = $request->get('designer');
        $job->client = $request->get('client');
        $job->media = $request->get('media');
        $job->status = $request->get('status');
        $job->created_by = Auth::user()->id;
        $job->related_manager = $request->get('manager');


       /*if(!empty($request->get('assigned'))) {
            $job->assigned_to = implode(',', $request->get('assigned'));
        }*/

        if($request->get('deadline')) {
            $date1 = strtr($request->get('deadline'), '/', '-');
            $job->deadline = date('Y-m-d', strtotime($date1));
        }

        $job->save();

        if($request->hasfile('file')) {

            $all_images = [];
            foreach($request->file('file') as $file)
            {
                $filename=$file->getClientOriginalName();
                $file->move(public_path().'/upload/', $filename);
                array_push($all_images, $filename);

                $job_upload = new JobUpload();
                $job_upload->job_id = $job->id;
                $job_upload->attached = $filename;
                $job_upload->save();
            }
            /*$job->attachment = implode(',',$all_images);*/
        }
        return Redirect::to("filtered-dashboard")->with('success','Job saved successfully');
    }

    public function edit($id)
    {
        $breadcrumbs = [
            ['link' => "modern", 'name' => "Home"], ['link' => "javascript:void(0)", 'name' => "User"], ['name' => "Users Edit"]];
        //Pageheader set true for breadcrumbs
        $pageConfigs = ['pageHeader' => false, 'isFabButton' => true];

        $jobs = Job::where('id', Crypt::decrypt($id))->first();
        
        $auth_user = Auth::user()->id;
        $brands_related_to_user = User::where('id',$auth_user)->first();
        $arr = explode(',',$brands_related_to_user->brands);
        $brands = Brand::whereIn('id',$arr)->get();

        $managers= User::where('status',1)->where('role',2)->get();
        $users = User::where('status',1)->get();
        $clients = User::where('status',1)->where('role',9)->get();
        $medias = User::where('status',1)->where('role',4)->get();
        $copy_writers = User::where('status',1)->where('role',3)->get();
        $designers = User::where('status',1)->where('role',7)->get();
        $strategy = User::where('status',1)->where('role',8)->get();
        $art = User::where('status',1)->where('role',5)->get();

        $job_uploads = JobUpload::where('job_id',Crypt::decrypt($id))->get();

        return view('jobs.page-jobs-edit', ['job_uploads'=>$job_uploads,'art'=>$art,'strategy'=>$strategy,'designers'=>$designers,'copy_writers'=>$copy_writers,'medias'=>$medias,'clients'=>$clients,'users'=>$users,'managers'=>$managers, 'brands'=>$brands, 'jobs'=>$jobs, 'pageConfigs' => $pageConfigs], ['breadcrumbs' => $breadcrumbs]);
    }

    public function update(Request $request, $id)
    {
        log::info(Crypt::decrypt($id));

        if(!empty($request->get('deadline'))) {
            $date1 = strtr($request->get('deadline'), '/', '-');
            $date1 = date('Y-m-d', strtotime($date1));
        }else{
            $date1 = null;
        }

        if(!empty($request->get('assigned'))) {
            $assigner = implode(',', $request->get('assigned'));
        }else{
            $assigner = null;
        }

        $jobs = DB::table('jobs')
            ->where('id', Crypt::decrypt($id))
            ->update([
                'product' => $request->get('product'),
                'description' =>$request->get('description'),
                'status' => $request->get('status'),
                'related_manager' => $request->get('manager'),
                'deadline' => date('Y-m-d', strtotime($date1)),
                'brand' => $request->get('brand'),
                'stratgy' => $request->get('strategy'),
                'copy' => $request->get('copy'),
                'art' => $request->get('art'),
                'media' => $request->get('media'),
                'client' => $request->get('client'),
                'designer' => $request->get('designer'),
                'str' => $request->get('str'),
                'cw' => $request->get('cw'),
                'des' => $request->get('des'),
                'hoc' => $request->get('hoc'),
                'mm' => $request->get('mm'),
            ]);

       /* $jobs_chk = DB::table('job_uploads')
                    ->where('job_id', Crypt::decrypt($id))
                    ->get();
                    
        if(count($jobs_chk) > 0){
            $jobs_chk = DB::table('job_uploads')
                    ->where('job_id', Crypt::decrypt($id))
                    ->delete();
        }*/
        
        if($request->hasfile('file')) {

            $all_images = [];
            foreach($request->file('file') as $file)
            {
                $filename=$file->getClientOriginalName();
                $file->move(public_path().'/upload/', $filename);
                $insert['name'] = "$filename";
                array_push($all_images, $filename);

                $job_upload = new JobUpload();
                $job_upload->job_id = Crypt::decrypt($id);
                $job_upload->attached = $filename;
                $job_upload->save();
                /*$jobs = DB::table('job_uploads')
                    ->where('job_id', Crypt::decrypt($id))
                    ->update(['attached'=> $filename]);*/
            }

        }

       /* if($request->hasfile('file-client')) {

            $all_images = [];
            foreach($request->file('file-client') as $file)
            {
                $filename=$file->getClientOriginalName();
                $file->move(public_path().'/upload/', $filename);
                $insert['name'] = "$filename";
                array_push($all_images, $filename);

                $jobs = DB::table('job_uploads')
                    ->where('id', Crypt::decrypt($id))
                    ->update(['attached_client'=> $filename]);
            }

        }*/
        return Redirect::to("filtered-dashboard")->with('success','Job updated successfully');

    }

    public function show($id)
    {
        $auth_user = Auth::user()->id;
        $get_user = User::where('id',$auth_user)->first();
        $get_user_role = $get_user->role;
        
        $get_job_details = Job::where('id', Crypt::decrypt($id))->first();

        $attached = JobUpload::where('job_id',Crypt::decrypt($id))->get();
        //get_client_name
        if($get_job_details->client != null) {
            $client = User::where('id', $get_job_details->client)->first();
            $client = $client->name;
        }else{
            $client = 'Not Available';
        }

        //get strategy name
        if($get_job_details->stratgy != null) {
            $strategy = User::where('id', $get_job_details->stratgy)->first();
            $strategy = $strategy->name;
        }else{
            $strategy = 'Not Available';
        }

        //get copy name
        if($get_job_details->copy != null) {
            $copy = User::where('id', $get_job_details->copy)->first();
            $copy = $copy->name;
        }else{
            $copy = 'Not Available';
        }

        //get designer name
        if($get_job_details->designer != null) {
            $designer = User::where('id', $get_job_details->designer)->first();
            $designer = $designer->name;
        }else{
            $designer = 'Not Available';
        }

        //get art name
        if($get_job_details->art != null) {
            $art = User::where('id', $get_job_details->art)->first();
            $art = $art->name;
        }else{
            $art = 'Not Available';
        }

        //get media name
        if($get_job_details->media != null) {
            $media = User::where('id', $get_job_details->media)->first();
            $media = $media->name;
        }else{
            $media = 'Not Available';
        }

        if(!empty($get_job_details->brand)) {
            $related_brands = explode(',',$get_job_details->brand);
            $brands = Brand::wherein('id', $related_brands)->get();
        }else{
            $brands = null;
        }

        if(!empty($get_job_details->assigned_to)) {
            $related_asigners = explode(',', $get_job_details->assigned_to);
            $assigners = User::wherein('id', $related_asigners)->get();
        }else{
            $assigners = null;
        }

        $manager = User::where('id', $get_job_details->related_manager)->first();

        $comments_attached = JobComment::where('job_id',Crypt::decrypt($id))->get();

        return view('jobs.page-jobs-view',['get_user_role'=> $get_user_role,'comments_attached'=>$comments_attached, 'attached'=>$attached,'strategy'=>$strategy,'copy'=>$copy,'designer'=>$designer,'art'=>$art, 'media'=>$media,'client'=>$client,'manager'=>$manager, 'get_job_details'=> $get_job_details, 'assigners'=>$assigners,'brands'=>$brands]);
    }

    public function viewUpdate(Request $request,$id){
        $jobs = DB::table('jobs')
            ->where('id', Crypt::decrypt($id))
            ->update([
                'status' => $request->get('status'),
                'str' => $request->get('str'),
                'cw' => $request->get('cw'),
                'des' => $request->get('des'),
                'hoc' => $request->get('hoc'),
                'mm' => $request->get('mm'),
            ]);

        return $this->show($id);
    }

    public function downloadFile($name){
        $file= public_path(). "/upload/".$name;
        $headers = [
            'Content-Type' => 'application/pdf','image/gif','image/png','image/jpeg','video/mp4'
        ];

        return response()->download($file, $name, $headers);
    }

    public function deleteAttached($id,$job_id){

        $jobs =  JobUpload::where('id',$job_id)->delete();

        return Redirect::to("page-jobs-edit/".$id);
    }

    public function destroy($id)
    {
        $jobs =  Job::where('id',Crypt::decrypt($id))->delete();
        return Redirect::to("page-jobs-list")->with('success','Job deleted successfully');
    }

    public function clientFeedback(Request $request){

        $jobs = DB::table('jobs')
            ->where('id', $request->get('jobid'))
            ->update([
                'cl_feedback' => $request->get('id'),
            ]);

    }

    public function clone($id){

        $job = Job::withTrashed()->latest()->first();
        if(!empty($job) > 0) {
            $job_id = $job->id + 1;
        }else{
            $job_id = 1;
        }
        $job_no = 'JOB'.str_pad($job_id,5,'0',STR_PAD_LEFT);
        $auth_user = Auth::user()->id;

        $jobs = DB::table('jobs')
            ->where('id', Crypt::decrypt($id))
            ->first();

        if(!empty($jobs->assigned)) {
            $assigner = implode(',', $jobs->assigned);
        }else{
            $assigner = null;
        }

        if(!empty($jobs->strategy)) {
            $strategy = $jobs->strategy;
        }else{
            $strategy = null;
        }

        if(!empty($jobs->manager)) {
            $manager = $jobs->manager;
        }else{
            $manager = null;
        }

        $job  = new Job();
        $job->job_no = $job_no;
        $job->product = 'Reject Clone - '.$jobs->product;
        $job->description = $jobs->description;
        $job->brand = $jobs->brand;
        $job->stratgy = $strategy;
        $job->copy = $jobs->copy;
        $job->art = $jobs->art;
        $job->designer = $jobs->designer;
        $job->client = $jobs->client;
        $job->media = $jobs->media;
        $job->status = $jobs->status;
        $job->created_by = $auth_user;
        $job->related_manager = $manager;
        $job->deadline = $jobs->deadline;


        $job->save();

        return Redirect::to("filtered-dashboard");
        /*if($request->hasfile('file')) {

            $all_images = [];
            foreach ($request->file('file') as $file) {
                $filename = $file->getClientOriginalName();
                $file->move(public_path() . '/upload/', $filename);
                array_push($all_images, $filename);

                $job_upload = new JobUpload();
                $job_upload->job_id = $job->id;
                $job_upload->attached = $filename;
                $job_upload->save();
            }
        }*/
    }
}
