<?php

namespace App\Http\Controllers;

use App\Brand;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;
use Illuminate\Http\RedirectResponse;
use Laracasts\Flash\Flash;
use Illuminate\Support\Facades\Crypt;

class BrandController extends Controller
{

    public function index()
    {
        $breadcrumbs = [
            ['link' => "modern", 'name' => "Home"], ['link' => "javascript:void(0)", 'name' => "Brand"], ['name' => "Brands"]];
        //Pageheader set true for breadcrumbs
        $pageConfigs = ['pageHeader' => false, 'isFabButton' => true];
        $brands = Brand::all();

        return view('brands.page-brands-list', ['brands'=>$brands, 'pageConfigs' => $pageConfigs], ['breadcrumbs' => $breadcrumbs]);
    }

    public function create()
    {
        $breadcrumbs = [
            ['link' => "modern", 'name' => "Home"], ['link' => "javascript:void(0)", 'name' => "User"], ['name' => "Users List"]];
        //Pageheader set true for breadcrumbs
        $pageConfigs = ['pageHeader' => false, 'isFabButton' => true];

        return view('brands.page-brands-add', ['pageConfigs' => $pageConfigs], ['breadcrumbs' => $breadcrumbs]);
    }

    public function customUrl(){
        $url = Str::random(32);
        return $url;
    }

    public function store(Request $request)
    {
        request()->validate([
            'name' => 'required',
            'code' => 'required',
        ]);

        $brand  = new Brand();
        $brand->url = $this->customUrl();
        $brand->name = $request->get('name');
        $brand->code = $request->get('code');
        $brand->status = 1;
        $brand->save();

        return Redirect::to("page-brands-list")->with('success','Brand saved successfully');
    }

    public function edit($id)
    {
        $breadcrumbs = [
            ['link' => "modern", 'name' => "Home"], ['link' => "javascript:void(0)", 'name' => "User"], ['name' => "Users Edit"]];
        //Pageheader set true for breadcrumbs
        $pageConfigs = ['pageHeader' => false, 'isFabButton' => true];
        $brands = Brand::where('id', Crypt::decrypt($id))->first();

        return view('brands.page-brands-edit', ['brands'=>$brands, 'pageConfigs' => $pageConfigs], ['breadcrumbs' => $breadcrumbs]);
    }

    public function update(Request $request, $id)
    {
        $brands = DB::table('brands')
            ->where('id', Crypt::decrypt($id))
            ->update(['name' => $request->get('name'), 'code' =>$request->get('code')]);

        return Redirect::to("page-brands-list")->with('success','Brand updated successfully');

    }

    public function show($id)
    {
        //
    }

    public function destroy($id)
    {
        $brands =  Brand::where('id',Crypt::decrypt($id))->delete();
        return Redirect::to("page-brands-list")->with('success','Brand deleted successfully');
    }
}
