<?php

namespace App\Http\Controllers;
use App\Job;
use App\User;
use App\Brand;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Session;;
use Illuminate\Support\Facades\Log;
use Illuminate\Foundation\Validation;

class AuthController extends Controller
{
    /*public $successStatus = 200;
    //register api
    public function register(Request $request){

        $validator = Validator::make($request->all(), [ 
            'name' => 'required', 
            'email' => 'required|email', 
            'password' => 'required', 
            'c_password' => 'required|same:password', 
        ]);

        if($validator->fails()){
          return response()->json(['error'=>$validator->errors()],401);
        }

      $input = $request->all(); 
        $input['password'] = bcrypt($input['password']); 
        $user = User::create($input); 
        $success['token'] =  $user->createToken('Personal Access Token')->accessToken; 
        $success['name'] =  $user->name;
      return response()->json(['success'=>$success], $this->successStatus);
    } 

    // login api
    public function login(){
      if(Auth::attempt(['email' => request('email'), 'password' => request('password')])){
        $user = Auth::user();
        $success['token'] = $user->createToken('LoginToken')->accessToken;
        $success['name'] = $user->name;
      return response()->json(['success'=>$success],$this->successStatus);
      }
      else{
        return response()->json(['error'=>'Unauthorised'],401);
      }
    }

    // user detail api
    public function user(){
      $user = Auth::user();
      return response()->json(['success' => $user], $this->successStatus); 
    }

    // user logout api
    public function logout(){
      $user = Auth::user();
      return response()->json(['success'=>'Successfully Logout!']);
    }*/

    public function index()
    {
        return view('auth/user-login');
    }

    public function register()
    {
        return view('auth/user-register');
    }

    public function postLogin(Request $request)
    {
        request()->validate([
            'email' => 'required',
            'password' => 'required',
        ]);

        if (Auth::attempt(['email' => $request->get('email'), 'password' => $request->get('password')])) {

            $status = $request->get('status');
            $brand = $request->get('brand');
            $all_brands = Brand::where('status',1)->get();
            $user = $request->get('user');
            $all_users = User::where('status',1)->get();
            $auth_user_id = Auth::user()->id;
            $role = Auth::user()->role;
            $brands_user = User::where('id',$auth_user_id)->get();
            $array = explode(',',$brands_user[0]->brands);
            $brands = Brand::whereIn('id', $array)->get();

            $assigned = 0;
            $pending = 0;
            $completed =0;
            if(Auth::check()){
                $assigned = Job::where('deleted_at',null)->count();
                $completed = Job::where('cl_feedback','!=',0)->count();
                if($assigned > 0){
                    $pending = $assigned - $completed;
                }
                if($status == 0){
                    $status = null;
                }
                // Admin and CEO
                if(Auth::user()->role == 1 || Auth::user()->role == 6) {
                    if(empty($status) && empty($brand) && empty($user)){
                        $jobs = Job::orderby('created_at', 'DESC')->get();
                    } elseif (!empty($status) && empty($brand) && empty($user)) {
                        $jobs = Job::where('status', $status)->orderby('created_at', 'DESC')->get();
                    } elseif (empty($status) && !empty($brand) && empty($user)) {
                        $jobs = Job::where('brand', $brand)->orderby('created_at', 'DESC')->get();
                    } elseif (empty($status) && empty($brand) && !empty($user)) {
                        $jobs = Job::where('created_by', $user)
                            ->orWhere('related_manager', $user)
                            ->orWhere('stratgy',$user)
                            ->orWhere('copy',$user)
                            ->orWhere('designer',$user)
                            ->orWhere('art',$user)
                            ->orWhere('media',$user)
                            ->orWhere('client',$user)
                            ->orderby('created_at', 'DESC')->get();
                    }elseif (!empty($status) && !empty($brand) && empty($user)) {
                        $jobs = Job::where('status', $status)->where('brand', $brand)->orderby('created_at', 'DESC')->get();
                    }elseif (!empty($status) && empty($brand) && !empty($user)) {
                        $jobs = Job::where('status', $status)
                            ->orWhere('created_by', $user)
                            ->orWhere('related_manager', $user)
                            ->orWhere('stratgy',$user)
                            ->orWhere('copy',$user)
                            ->orWhere('designer',$user)
                            ->orWhere('art',$user)
                            ->orWhere('media',$user)
                            ->orWhere('client',$user)
                            ->orderby('created_at', 'DESC')->get();
                    }elseif (empty($status) && !empty($brand) && !empty($user)) {
                        $jobs = Job::where('brand', $brand)
                            ->orWhere('created_by', $user)
                            ->orWhere('related_manager', $user)
                            ->orWhere('stratgy',$user)
                            ->orWhere('copy',$user)
                            ->orWhere('designer',$user)
                            ->orWhere('art',$user)
                            ->orWhere('media',$user)
                            ->orWhere('client',$user)
                            ->orderby('created_at', 'DESC')->get();
                    }elseif (empty($status) && !empty($brand) && !empty($user)) {
                        $jobs = Job::where('status', $status)
                            ->orWhere('created_by', $user)
                            ->where('brand', $brand)
                            ->orWhere('related_manager', $user)
                            ->orWhere('stratgy',$user)
                            ->orWhere('copy',$user)
                            ->orWhere('designer',$user)
                            ->orWhere('art',$user)
                            ->orWhere('media',$user)
                            ->orWhere('client',$user)
                            ->orderby('created_at', 'DESC')->get();
                    }else{
                        $jobs = null;
                    }

                    return view('pages.dashboard-modern', ['assigned'=>$assigned, 'pending'=>$pending, 'completed'=>$completed, 'role'=>$role,'auth_user_id'=>$auth_user_id,'all_users'=>$all_users,'jobs' => $jobs, 'brands' => $brands]);

                    // Account Manager Role
                }elseif(Auth::user()->role == 2){
                    $assigned = Job::where('created_by',$auth_user_id)->count();
                    $completed = Job::where('created_by',$auth_user_id)->where('cl_feedback','!=',0)->count();
                    if($assigned > 0){
                        $pending = $assigned - $completed;
                    }else{
                        $pending = 0;
                    }

                    $jobs = Job::where('created_by', $auth_user_id)->orderby('created_at', 'DESC')->get();

               
                    return view('pages.dashboard-modern', ['assigned'=>$assigned, 'pending'=>$pending, 'completed'=>$completed,'role'=>$role,'auth_user_id'=>$auth_user_id,'all_users'=>$all_users,'jobs' => $jobs, 'brands' => $brands]);

                    // Copy Writer
                }elseif(Auth::user()->role == 3){
                    $assigned = Job::where('copy',$auth_user_id)->count();
                    $completed = Job::where('copy',$auth_user_id)->where('status','>',5)->count();
                    if($assigned > 0){
                        $pending = $assigned - $completed;
                    }else{
                        $pending = 0;
                    }
                    
                    if(empty($status)){
                        $status = 4;
                    }
                    $jobs = Job::where('copy', $auth_user_id)->orderby('created_at', 'DESC')->get();
                    return view('pages.dashboard-modern', ['assigned'=>$assigned, 'pending'=>$pending, 'completed'=>$completed,'role'=>$role,'auth_user_id'=>$auth_user_id,'all_users'=>$all_users,'jobs' => $jobs, 'brands' => $brands]);

                // Media manager
                }elseif(Auth::user()->role == 4){
                    $assigned = Job::where('media',$auth_user_id)->count();
                    $completed = Job::where('media',$auth_user_id)->where('status','>',9)->count();
                    if($assigned > 0){
                        $pending = $assigned - $completed;
                    }else{
                        $pending = 0;
                    }


                    $jobs = Job::where('media', $auth_user_id)->orderby('created_at', 'DESC')->get();

                    return view('pages.dashboard-modern', ['assigned'=>$assigned, 'pending'=>$pending, 'completed'=>$completed,'role'=>$role,'auth_user_id'=>$auth_user_id,'all_users'=>$all_users,'jobs' => $jobs, 'brands' => $brands]);

                    //Head of creative
                }elseif(Auth::user()->role == 5){

                    $assigned = Job::where('designer','!=', null)->count();
                    $completed = Job::where('designer','!=', null)->where('status',8)->count();
                    if($assigned > 0){
                        $pending = $assigned - $completed;
                    }else{
                        $pending = 0;
                    }

                    if(empty($status)){
                        $status = 6;
                    }
                    if(empty($status) && empty($brand) && empty($user)){
                        $jobs = Job::orderby('created_at', 'DESC')->get();
                    } elseif (!empty($status) && empty($brand) && empty($user)) {
                        $jobs = Job::where('status', $status)->orderby('created_at', 'DESC')->get();
                    } elseif (empty($status) && !empty($brand) && empty($user)) {
                        $jobs = Job::where('brand', $brand)->orderby('created_at', 'DESC')->get();
                    } elseif (empty($status) && empty($brand) && !empty($user)) {
                        $jobs = Job::where('art',$user)->orderby('created_at', 'DESC')->get();
                    }elseif (!empty($status) && !empty($brand) && empty($user)) {
                        $jobs = Job::where('status', $status)->where('brand', $brand)->orderby('created_at', 'DESC')->get();
                    }elseif (!empty($status) && empty($brand) && !empty($user)) {
                        $jobs = Job::where('status', $status)->here('art',$user)->orderby('created_at', 'DESC')->get();
                    }elseif (empty($status) && !empty($brand) && !empty($user)) {
                        $jobs = Job::where('brand', $brand)->where('art',$user)->orderby('created_at', 'DESC')->get();
                    }elseif (!empty($status) && !empty($brand) && !empty($user)) {
                        $jobs = Job::where('status', $status)->where('brand', $brand)->where('art',$user)->orderby('created_at', 'DESC')->get();
                    }
                    return view('pages.dashboard-modern', ['assigned'=>$assigned, 'pending'=>$pending, 'completed'=>$completed,'role'=>$role,'auth_user_id'=>$auth_user_id,'all_users'=>$all_users,'jobs' => $jobs, 'brands' => $brands]);

                    //Designer
                }elseif(Auth::user()->role == 7){

                    $assigned = Job::where('designer', $auth_user_id)->count();
                    $completed = Job::where('designer', $auth_user_id)->where('status','>',7)->count();
                    if($assigned > 0){
                        $pending = $assigned - $completed;
                    }else{
                        $pending = 0;
                    }

                    if(empty($status)){
                        $status = 6;
                    }

                    $jobs = Job::where('designer', $auth_user_id)->orderby('created_at', 'DESC')->get();

                    return view('pages.dashboard-modern', ['assigned'=>$assigned, 'pending'=>$pending, 'completed'=>$completed,'role'=>$role,'auth_user_id'=>$auth_user_id,'all_users'=>$all_users,'jobs' => $jobs, 'brands' => $brands]);

                    //strategy
                }elseif(Auth::user()->role == 8){

                    $assigned = Job::where('stratgy', $auth_user_id)->count();
                    $completed = Job::where('stratgy', $auth_user_id)->where('status',4)->count();
                    if($assigned > 0){
                        $pending = $assigned - $completed;
                    }else{
                        $pending = 0;
                    }

                    if(empty($status)){
                        $status = 2;
                    }

                    if(empty($status) && empty($brand) && empty($user)){
                        $jobs = Job::orderby('created_at', 'DESC')->get();
                    } elseif (!empty($status) && empty($brand) && empty($user)) {
                        $jobs = Job::where('status', $status)->orderby('created_at', 'DESC')->get();
                    } elseif (empty($status) && !empty($brand) && empty($user)) {
                        $jobs = Job::where('brand', $brand)->orderby('created_at', 'DESC')->get();
                    } elseif (empty($status) && empty($brand) && !empty($user)) {
                        $jobs = Job::where('stratgy',$user)->orderby('created_at', 'DESC')->get();
                    }elseif (!empty($status) && !empty($brand) && empty($user)) {
                        $jobs = Job::where('status', $status)->where('brand', $brand)->orderby('created_at', 'DESC')->get();
                    }elseif (!empty($status) && empty($brand) && !empty($user)) {
                        $jobs = Job::where('status', $status)->here('stratgy',$user)->orderby('created_at', 'DESC')->get();
                    }elseif (empty($status) && !empty($brand) && !empty($user)) {
                        $jobs = Job::where('brand', $brand)->where('stratgy',$user)->orderby('created_at', 'DESC')->get();
                    }elseif (!empty($status) && !empty($brand) && !empty($user)) {
                        $jobs = Job::where('status', $status)->where('brand', $brand)->where('stratgy',$user)->orderby('created_at', 'DESC')->get();
                    }

                    return view('pages.dashboard-modern', ['assigned'=>$assigned, 'pending'=>$pending, 'completed'=>$completed,'role'=>$role,'auth_user_id'=>$auth_user_id,'all_users'=>$all_users,'jobs' => $jobs, 'brands' => $brands]);

                    //client
                }elseif(Auth::user()->role == 9){
                    $assigned = Job::where('client', $auth_user_id)->count();
                    $completed = Job::where('client', $auth_user_id)->where('status',11)->count();
                    if($assigned > 0){
                        $pending = $assigned - $completed;
                    }else{
                        $pending = 0;
                    }
$user = $auth_user_id;
                    if(empty($status) && empty($brand) && empty($user)){
                        $jobs = Job::orderby('created_at', 'DESC')->get();
                    } elseif (!empty($status) && empty($brand) && empty($user)) {
                        $jobs = Job::where('status', $status)->orderby('created_at', 'DESC')->get();
                    } elseif (empty($status) && !empty($brand) && empty($user)) {
                        $jobs = Job::where('brand', $brand)->orderby('created_at', 'DESC')->get();
                    } elseif (empty($status) && empty($brand) && !empty($user)) {
                        $jobs = Job::where('client',$user)->orderby('created_at', 'DESC')->get();
                    }elseif (!empty($status) && !empty($brand) && empty($user)) {
                        $jobs = Job::where('status', $status)->where('brand', $brand)->orderby('created_at', 'DESC')->get();
                    }elseif (!empty($status) && empty($brand) && !empty($user)) {
                        $jobs = Job::where('status', $status)->here('client',$user)->orderby('created_at', 'DESC')->get();
                    }elseif (empty($status) && !empty($brand) && !empty($user)) {
                        $jobs = Job::where('brand', $brand)->where('client',$user)->orderby('created_at', 'DESC')->get();
                    }elseif (!empty($status) && !empty($brand) && !empty($user)) {
                        $jobs = Job::where('status', $status)->where('brand', $brand)->where('client',$user)->orderby('created_at', 'DESC')->get();
                    }

                    return view('pages.dashboard-modern', ['assigned'=>$assigned, 'pending'=>$pending, 'completed'=>$completed,'role'=>$role,'auth_user_id'=>$auth_user_id,'all_users'=>$all_users,'jobs' => $jobs, 'brands' => $brands]);

                }elseif(Auth::user()->role == 10){

                }
            }

        }
        return Redirect::to("user-login")->withSuccess('Oppes! You have entered invalid credentials');
    }

    public function postRegister(Request $request)
    {
        request()->validate([
            'name' => 'required',
            'email' => 'required|email|unique:users',
            'password' => 'required|min:6',
        ]);
        $user = User::create(request(['name', 'email', 'password']));
        $jobs = Job::all();
        return Redirect::to("dashboard-modern", ['jobs' => $jobs])->withSuccess('Great! You have Successfully loggedin');
    }

    public function dashboard()
    {
        if(Auth::check()){
            $jobs = Job::orderby('created_at','DESC')->get();
            return view('dashboard', ['jobs' => $jobs]);
        }
        return Redirect::to("user-login")->withSuccess('Opps! You do not have access');
    }

    public function filteredDashboard(Request $request)
    {
        $status = $request->get('status');
        $brand = $request->get('brand');
        $fstatus = $request->get('fstatus');
        $all_brands = Brand::where('status',1)->get();
        $user = $request->get('user');
        $all_users = User::where('status',1)->get();
        $auth_user_id = Auth::user()->id;
        $role = Auth::user()->role;
        $brands_user = User::where('id',$auth_user_id)->get();
        $array = explode(',',$brands_user[0]->brands);
        $brands = Brand::whereIn('id', $array)->get();

        $assigned = 0;
        $pending = 0;
        $completed = 0;

        if($status == 0){
            $status = null;
        }
        if(Auth::check()){
            // Admin and CEO
            $assigned = Job::where('deleted_at',null)->count();
            $completed = Job::where('cl_feedback','!=',0)->count();
            if($assigned > 0){
                $pending = $assigned - $completed;
            }
            
            log::info($fstatus);
            
            if($fstatus != null){
                $jobs = Job::where('cl_feedback','=',$fstatus)->orderby('created_at', 'DESC')->get();
                return view('pages.dashboard-modern', ['assigned'=>$assigned, 'pending'=>$pending, 'completed'=>$completed,'role'=>$role,'auth_user_id'=>$auth_user_id,'all_users'=>$all_users,'jobs' => $jobs, 'brands' => $brands]);

            }
            
            if(Auth::user()->role == 1 || Auth::user()->role == 6) {


            
                if(empty($status) && empty($brand) && empty($user)){
                    $jobs = Job::orderby('created_at', 'DESC')->get();
                } elseif (!empty($status) && empty($brand) && empty($user)) {
                    $jobs = Job::where('status', $status)->orderby('created_at', 'DESC')->get();
                } elseif (empty($status) && !empty($brand) && empty($user)) {
                    $jobs = Job::where('brand', $brand)->orderby('created_at', 'DESC')->get();
                } elseif (empty($status) && empty($brand) && !empty($user)) {
                    $jobs = Job::where('created_by', $user)
                        ->orWhere('related_manager', $user)
                        ->orWhere('stratgy',$user)
                        ->orWhere('copy',$user)
                        ->orWhere('designer',$user)
                        ->orWhere('art',$user)
                        ->orWhere('media',$user)
                        ->orWhere('client',$user)
                        ->orderby('created_at', 'DESC')->get();
                }elseif (!empty($status) && !empty($brand) && empty($user)) {
                    $jobs = Job::where('status', $status)->where('brand', $brand)->orderby('created_at', 'DESC')->get();
                }elseif (!empty($status) && empty($brand) && !empty($user)) {
                    $jobs = Job::where('status', $status)
                        ->Where('created_by', $user)
                        ->orWhere('related_manager', $user)
                        ->orWhere('stratgy',$user)
                        ->orWhere('copy',$user)
                        ->orWhere('designer',$user)
                        ->orWhere('art',$user)
                        ->orWhere('media',$user)
                        ->orWhere('client',$user)
                        ->orderby('created_at', 'DESC')->get();
                }elseif (empty($status) && !empty($brand) && !empty($user)) {
                    $jobs = Job::where('brand', $brand)
                        ->Where('created_by', $user)
                        ->orWhere('related_manager', $user)
                        ->orWhere('stratgy',$user)
                        ->orWhere('copy',$user)
                        ->orWhere('designer',$user)
                        ->orWhere('art',$user)
                        ->orWhere('media',$user)
                        ->orWhere('client',$user)
                        ->orderby('created_at', 'DESC')->get();
                }elseif (!empty($status) && !empty($brand) && !empty($user)) {
                    $jobs = Job::where('status', $status)
                        ->where('brand', $brand)
                        ->Where('created_by', $user)
                        ->orWhere('related_manager', $user)
                        ->orWhere('stratgy',$user)
                        ->orWhere('copy',$user)
                        ->orWhere('designer',$user)
                        ->orWhere('art',$user)
                        ->orWhere('media',$user)
                        ->orWhere('client',$user)
                        ->orderby('created_at', 'DESC')->get();
                }else{
                    $jobs = null;
                }


                return view('pages.dashboard-modern', ['assigned'=>$assigned, 'pending'=>$pending, 'completed'=>$completed,'role'=>$role,'auth_user_id'=>$auth_user_id,'all_users'=>$all_users,'jobs' => $jobs, 'brands' => $brands]);

            // Account Manager Role
            }elseif(Auth::user()->role == 2){
                $assigned = Job::where('created_by',$auth_user_id)->count();
                $completed = Job::where('cl_feedback','!=',0)->where('created_by',$auth_user_id)->count();
                if($assigned > 0){
                    $pending = $assigned - $completed;
                }else{
                   $pending = 0;
                }
                
                if($brand == 0){
                    $brand = null;
                }
                
                if($status == 0){
                    $status = null;
                }
                
                if(empty($status) && empty($brand)){
                    $jobs = Job::where('created_by',$auth_user_id)->orderby('created_at', 'DESC')->get();
                } elseif (!empty($status) && empty($brand)) {
                    $jobs = Job::where('status', $status)->where('created_by',$auth_user_id)->orderby('created_at', 'DESC')->get();
                } elseif (empty($status) && !empty($brand)) {
                    $jobs = Job::where('brand', $brand)->where('created_by',$auth_user_id)->orderby('created_at', 'DESC')->get();
                } elseif (!empty($status) && !empty($brand)) {
                    $jobs = Job::where('brand', $brand)->where('status', $status)->where('created_by',$auth_user_id)->orderby('created_at', 'DESC')->get();
                } 
                
                return view('pages.dashboard-modern', ['assigned'=>$assigned, 'pending'=>$pending, 'completed'=>$completed,'role'=>$role,'auth_user_id'=>$auth_user_id,'all_users'=>$all_users,'jobs' => $jobs, 'brands' => $brands]);

            // Copy Writer
            }elseif(Auth::user()->role == 3){
                $assigned = Job::where('copy',$auth_user_id)->count();
                $completed = Job::where('copy',$auth_user_id)->where('status','>',5)->count();
                if($assigned > 0){
                    $pending = $assigned - $completed;
                }else{
                        $pending = 0;
                    }
                    
                if($brand == 0){
                    $brand = null;
                }

                if(empty($brand)){
                    $jobs = Job::where('copy', $auth_user_id)->orderby('created_at', 'DESC')->get();
                }else{
                    $jobs = Job::where('copy', $auth_user_id)->where('brand', $brand)->orderby('created_at', 'DESC')->get();
                }

                return view('pages.dashboard-modern', ['assigned'=>$assigned, 'pending'=>$pending, 'completed'=>$completed,'role'=>$role,'auth_user_id'=>$auth_user_id,'all_users'=>$all_users,'jobs' => $jobs, 'brands' => $brands]);

            //Media manager
            }elseif(Auth::user()->role == 4){
                $assigned = Job::where('media',$auth_user_id)->count();
                $completed = Job::where('media',$auth_user_id)->where('status','>',9)->count();
                if($assigned > 0){
                    $pending = $assigned - $completed;
                }else{
                        $pending = 0;
                    }

                if($brand == 0){
                    $brand = null;
                }

                if(empty($brand)){
                    $jobs = Job::where('media', $auth_user_id)->orderby('created_at', 'DESC')->get();
                }else{
                    $jobs = Job::where('media', $auth_user_id)->where('brand', $brand)->orderby('created_at', 'DESC')->get();
                }
                return view('pages.dashboard-modern', ['assigned'=>$assigned, 'pending'=>$pending, 'completed'=>$completed,'role'=>$role,'auth_user_id'=>$auth_user_id,'all_users'=>$all_users,'jobs' => $jobs, 'brands' => $brands]);

            //Head of creative
            }elseif(Auth::user()->role == 5){
                $assigned = Job::where('designer','!=', null)->count();
                $completed = Job::where('designer','!=', null)->where('status',8)->count();
                if($assigned > 0){
                    $pending = $assigned - $completed;
                }else{
                        $pending = 0;
                    }

                if(empty($status)){
                    $status = 6;
                }
                if(empty($status) && empty($brand) && empty($user)){
                    $jobs = Job::orderby('created_at', 'DESC')->get();
                } elseif (!empty($status) && empty($brand) && empty($user)) {
                    $jobs = Job::where('status', $status)->orderby('created_at', 'DESC')->get();
                } elseif (empty($status) && !empty($brand) && empty($user)) {
                    $jobs = Job::where('brand', $brand)->orderby('created_at', 'DESC')->get();
                } elseif (empty($status) && empty($brand) && !empty($user)) {
                    $jobs = Job::where('art',$user)->orderby('created_at', 'DESC')->get();
                }elseif (!empty($status) && !empty($brand) && empty($user)) {
                    $jobs = Job::where('status', $status)->where('brand', $brand)->orderby('created_at', 'DESC')->get();
                }elseif (!empty($status) && empty($brand) && !empty($user)) {
                    $jobs = Job::where('status', $status)->here('art',$user)->orderby('created_at', 'DESC')->get();
                }elseif (empty($status) && !empty($brand) && !empty($user)) {
                    $jobs = Job::where('brand', $brand)->where('art',$user)->orderby('created_at', 'DESC')->get();
                }elseif (!empty($status) && !empty($brand) && !empty($user)) {
                    $jobs = Job::where('status', $status)->where('brand', $brand)->where('art',$user)->orderby('created_at', 'DESC')->get();
                }
                return view('pages.dashboard-modern', ['assigned'=>$assigned, 'pending'=>$pending, 'completed'=>$completed,'role'=>$role,'auth_user_id'=>$auth_user_id,'all_users'=>$all_users,'jobs' => $jobs, 'brands' => $brands]);

            //Designer
            }elseif(Auth::user()->role == 7){
                $assigned = Job::where('designer', $auth_user_id)->count();
                $completed = Job::where('designer', $auth_user_id)->where('status','>',7)->count();

                if($assigned > 0){
                    $pending = $assigned - $completed;
                }else{
                        $pending = 0;
                    }

                if($brand == 0){
                    $brand = null;
                }

                if(empty($brand)){
                    $jobs = Job::where('designer', $auth_user_id)->orderby('created_at', 'DESC')->get();
                }else{
                    $jobs = Job::where('designer', $auth_user_id)->where('brand', $brand)->orderby('created_at', 'DESC')->get();
                }

                return view('pages.dashboard-modern', ['assigned'=>$assigned, 'pending'=>$pending, 'completed'=>$completed,'role'=>$role,'auth_user_id'=>$auth_user_id,'all_users'=>$all_users,'jobs' => $jobs, 'brands' => $brands]);

            //strategy
            }elseif(Auth::user()->role == 8){
                $assigned = Job::where('stratgy', $auth_user_id)->count();
                $completed = Job::where('stratgy', $auth_user_id)->where('status',4)->count();
                if($assigned > 0){
                    $pending = $assigned - $completed;
                }else{
                        $pending = 0;
                    }

                if(empty($status)){
                    $status = 2;
                }

                if(empty($status) && empty($brand) && empty($user)){
                    $jobs = Job::orderby('created_at', 'DESC')->get();
                } elseif (!empty($status) && empty($brand) && empty($user)) {
                    $jobs = Job::where('status', $status)->orderby('created_at', 'DESC')->get();
                } elseif (empty($status) && !empty($brand) && empty($user)) {
                    $jobs = Job::where('brand', $brand)->orderby('created_at', 'DESC')->get();
                } elseif (empty($status) && empty($brand) && !empty($user)) {
                    $jobs = Job::where('stratgy',$user)->orderby('created_at', 'DESC')->get();
                }elseif (!empty($status) && !empty($brand) && empty($user)) {
                    $jobs = Job::where('status', $status)->where('brand', $brand)->orderby('created_at', 'DESC')->get();
                }elseif (!empty($status) && empty($brand) && !empty($user)) {
                    $jobs = Job::where('status', $status)->here('stratgy',$user)->orderby('created_at', 'DESC')->get();
                }elseif (empty($status) && !empty($brand) && !empty($user)) {
                    $jobs = Job::where('brand', $brand)->where('stratgy',$user)->orderby('created_at', 'DESC')->get();
                }elseif (!empty($status) && !empty($brand) && !empty($user)) {
                    $jobs = Job::where('status', $status)->where('brand', $brand)->where('stratgy',$user)->orderby('created_at', 'DESC')->get();
                }

                return view('pages.dashboard-modern', ['assigned'=>$assigned, 'pending'=>$pending, 'completed'=>$completed,'role'=>$role,'auth_user_id'=>$auth_user_id,'all_users'=>$all_users,'jobs' => $jobs, 'brands' => $brands]);

            //client
            }elseif(Auth::user()->role == 9){
                $assigned = Job::where('client', $auth_user_id)->count();
                $completed = Job::where('client', $auth_user_id)->where('status',11)->count();
                if($assigned > 0){
                    $pending = $assigned - $completed;
                }else{
                        $pending = 0;
                }

$user = $auth_user_id;
                if(empty($status) && empty($brand) && empty($user)){
                    $jobs = Job::orderby('created_at', 'DESC')->get();
                } elseif (!empty($status) && empty($brand) && empty($user)) {
                    $jobs = Job::where('status', $status)->orderby('created_at', 'DESC')->get();
                } elseif (empty($status) && !empty($brand) && empty($user)) {
                    $jobs = Job::where('brand', $brand)->orderby('created_at', 'DESC')->get();
                } elseif (empty($status) && empty($brand) && !empty($user)) {
                    $jobs = Job::where('client',$user)->orderby('created_at', 'DESC')->get();
                }elseif (!empty($status) && !empty($brand) && empty($user)) {
                    $jobs = Job::where('status', $status)->where('brand', $brand)->orderby('created_at', 'DESC')->get();
                }elseif (!empty($status) && empty($brand) && !empty($user)) {
                    $jobs = Job::where('status', $status)->here('client',$user)->orderby('created_at', 'DESC')->get();
                }elseif (empty($status) && !empty($brand) && !empty($user)) {
                    $jobs = Job::where('brand', $brand)->where('client',$user)->orderby('created_at', 'DESC')->get();
                }elseif (!empty($status) && !empty($brand) && !empty($user)) {
                    $jobs = Job::where('status', $status)->where('brand', $brand)->where('client',$user)->orderby('created_at', 'DESC')->get();
                }

                return view('pages.dashboard-modern', ['assigned'=>$assigned, 'pending'=>$pending, 'completed'=>$completed,'role'=>$role,'auth_user_id'=>$auth_user_id,'all_users'=>$all_users,'jobs' => $jobs, 'brands' => $brands]);

            }elseif(Auth::user()->role == 10){

            }
        }
    }


    /*public function create(array $data)
    {
        return User::create([
            'name' => $data['name'],
            'email' => $data['email'],
            'password' => Hash::make($data['password'])
        ]);
    }*/

    public function logout() {
        Session::flush();
        Auth::logout();
        return Redirect::to("user-login");
    }

}
