<?php

namespace App\Http\Controllers;

use App\JobComment;
use App\JobUpload;
use Illuminate\Support\Facades\Auth;
use App\Comment;
use App\Job;
use App\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Str;
use Illuminate\Database\Query\Builder;


class CommentController extends Controller
{
    public function store(Request $request)
    {
        $comment = new Comment();
        $comment->body = $request->get('comment_body');
        $comment->user()->associate($request->user());
        $post = Job::find($request->get('post_id'));

        $all_images = [];

        if($request->hasfile('file')) {
            foreach($request->file('file') as $file)
            {
                $filename=$file->getClientOriginalName();
                $file->move(public_path().'/upload/', $filename);
                array_push($all_images, $filename);
            }
        }

        $post->comments()->save($comment);

        if(count($all_images) > 0){
            foreach ($all_images as $ai){
                $job_file = new JobComment();
                $job_file->job_id = $request->get('post_id');
                $job_file->post_id = $comment->id;
                $job_file->comment_file = $ai;
                $job_file->save();
            }
        }

        return back();
    }

    public function replyStore(Request $request)
    {
        $reply = new Comment();
        $reply->body = $request->get('comment_body');
        $reply->user()->associate($request->user());
        $reply->parent_id = $request->get('comment_id');
        $post = Job::find($request->get('post_id'));

        $post->comments()->save($reply);

        return back();

    }
}