<?php if($message->from_user == \Auth::user()->id): ?>

    <div class="row msg_container base_sent" data-message-id="<?php echo e($message->id); ?>">
        <div class="col-md-10 col-xs-10">
            <div class="messages msg_sent text-right">
                <p><?php echo $message->content; ?></p>
                <time datetime="<?php echo e(date("Y-m-dTH:i", strtotime($message->created_at->toDateTimeString()))); ?>"><?php echo e($message->fromUser->name); ?> • <?php echo e($message->created_at->diffForHumans()); ?></time>
            </div>
        </div>
        <div class="col-md-2 col-xs-2 avatar">
            <img src="<?php echo e(url('images/user-avatar.png')); ?>" width="50" height="50" class="img-responsive">
        </div>
    </div>

<?php else: ?>

    <div class="row msg_container base_receive" data-message-id="<?php echo e($message->id); ?>">
        <div class="col-md-2 col-xs-2 avatar">
            <img src="<?php echo e(url('images/user-avatar.png')); ?>" width="50" height="50" class=" img-responsive ">
        </div>
        <div class="col-md-10 col-xs-10">
            <div class="messages msg_receive text-left">
                <p><?php echo $message->content; ?></p>
                <time datetime="<?php echo e(date("Y-m-dTH:i", strtotime($message->created_at->toDateTimeString()))); ?>"><?php echo e($message->fromUser->name); ?> • <?php echo e($message->created_at->diffForHumans()); ?></time>
            </div>
        </div>
    </div>

<?php endif; ?>