<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-5">
            <?php if($users->count() > 0): ?>
                <h3>Pick a user to chat with</h3>
                <ul id="users">
                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><span class="label label-info"><?php echo e($user->name); ?></span> <a href="javascript:void(0);" class="chat-toggle" data-id="<?php echo e($user->id); ?>" data-user="<?php echo e($user->name); ?>">Open chat</a></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            <?php else: ?>
                <p>No users found! try to add a new user using another browser</p>
            <?php endif; ?>
        </div>
    </div>

    <?php echo $__env->make('chat-box', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

    <input type="hidden" id="current_user" value="<?php echo e(\Auth::user()->id); ?>" />
    <input type="hidden" id="pusher_app_key" value="<?php echo e(env('PUSHER_APP_KEY')); ?>" />
    <input type="hidden" id="pusher_cluster" value="<?php echo e(env('PUSHER_APP_CLUSTER')); ?>" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script src="https://js.pusher.com/4.1/pusher.min.js"></script>
    <script src="<?php echo e(asset('js/chat.js')); ?>"></script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>